% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/retrieve_layers.R
\name{get_map_layer}
\alias{get_map_layer}
\title{Retrieve a map service layer from an ArcGIS REST API}
\usage{
get_map_layer(
  url,
  sf_object = NULL,
  bbox = NULL,
  bbox_crs = NULL,
  token = "",
  clip_raster = TRUE,
  format = "png",
  transparent = TRUE,
  add_legend = TRUE,
  ...
)
}
\arguments{
\item{url}{A character string of the url for the layer to pull}

\item{sf_object}{An \code{sf} object used for the bounding box}

\item{bbox}{Vector of bounding box coordinates}

\item{bbox_crs}{CRS for bbox (required if bbox is used)}

\item{token}{A character string of the token (if needed)}

\item{clip_raster}{Logical. Should the raster be clipped to contain only
the pixels that reside in the \code{sf_object}? By default, ArcGIS returns
some overlapping edge pixels. Setting \code{clip_raster} to TRUE (default)
will remove these using \code{\link[raster]{mask}} from the \code{raster}
package}

\item{format}{The raster format desired. Default is "png"}

\item{transparent}{Logical. Retrieve a raster with a transparent background
(TRUE, default) or not (FALSE)}

\item{add_legend}{Logical. Pull legend and match to color values
(TRUE, default) or not (FALSE)}

\item{...}{Additional arguments to pass to the ArcGIS REST API}
}
\value{
A "RasterLayer" object
}
\description{
This function retrieves map service layers from an ArcGIS
REST services API and returns them as a \code{RasterLayer} object
}
\details{
This is one of the core functions of the package. It retrieves map service
layers from an ArcGIS REST API designated by the URL. These layers require a
bounding box to query the map layer, which is either taken from the
\code{sf_object} argument or optionally can be passed via the \code{bbox}
argument. Either \code{sf_object} or \code{bbox} are optional, but one of
them must be present.

All of the querying parameters are sent via a POST request to the URL, so
if there are issues with passing additional parameters via \code{...}
first determine how they fit into the POST request and make adjustments as
needed. This syntax can be tricky if you're not used to it.
}
\examples{
\dontrun{
wi_landcover<- get_map_layer(wi_landcover_url, wis_poly)
plot_layer(wi_landcover, outline_poly = wis_poly)
}
}
