% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot,argoFloats-method}
\alias{plot,argoFloats-method}
\title{Plot an argoFloats Object}
\usage{
\S4method{plot}{argoFloats}(
  x,
  which = "map",
  bathymetry = argoDefaultBathymetry(),
  geographical = 0,
  xlim = NULL,
  ylim = NULL,
  xlab = NULL,
  ylab = NULL,
  type = "p",
  cex = par("cex"),
  col = par("fg"),
  pch = par("pch"),
  bg = par("bg"),
  eos = "gsw",
  mapControl = NULL,
  profileControl = NULL,
  QCControl = NULL,
  summaryControl = NULL,
  TSControl = NULL,
  debug = 0,
  ...
)
}
\arguments{
\item{x}{an \code{\linkS4class{argoFloats}} object.}

\item{which}{a character value indicating the type of plot. The possible
choices are \code{"map"}, \code{"profile"}, \code{"QC"}, \code{"summary"} and \code{"TS"};
see \dQuote{Details}.}

\item{bathymetry}{an argument used only if \code{which="map"}, to control
whether (and how) to indicate water depth. Note that the default
was \code{TRUE} until 2021-12-02, but was changed to \code{FALSE} on that
date, to avoid a bathymetry download, which can be a slow operations.
See \dQuote{Details} for details,
and Example 4 for a hint on compensating for the margin
adjustment done if an image is used to show bathymetry.}

\item{geographical}{flag indicating the style of axes
for the \code{which="map"} case, but only if no projection is called
for in the \code{mapControl} argument.  With \code{geographical=0} (which
is the default), the axis ticks are labeled with signed
longitudes and latitudes, measured in degrees. The signs are dropped
with \code{geographical=1}.
In the \code{geographical=4} case, signs are also dropped, but hemispheres
are indicated by writing \code{S}, \code{N}, \code{W} or \code{E} after axis tick labels,
except at the equator and prime meridian.
Note that this scheme mimics that used by \code{\link[oce:plot-coastline-method]{oce::plot,coastline-method()}}.}

\item{xlim, ylim}{numerical values, each a two-element vector, that
set the \code{x} and \code{y} limits of plot axes, as for \code{\link[=plot.default]{plot.default()}} and
other conventional plotting functions.}

\item{xlab}{a character value indicating the name for the horizontal axis, or
\code{NULL}, which indicates that this function should choose an appropriate name
depending on the value of \code{which}. Note that \code{xlab} is not obeyed if
\code{which="TS"}, because altering that label can be confusing to the user.}

\item{ylab}{as \code{xlab}, but for the vertical axis.}

\item{type}{a character value that controls the line type, with \code{"p"} for
unconnected points, \code{"l"} for line segments between undrawn points, etc.;
see the docs for \code{\link[=par]{par()}}, If \code{type} not specified, it defaults to \code{"p"}.}

\item{cex}{a character expansion factor for plot symbols, or \code{NULL}, to get an
value that depends on the value of \code{which}.}

\item{col}{the colour to be used for plot symbols, or \code{NULL}, to get an value
that depends on the value of \code{which} (see \dQuote{Details}).  If \code{which="TS"},
then the \code{TSControl} argument takes precedence over \code{col}.}

\item{pch}{an integer or character value indicating the type of plot symbol,
or \code{NULL}, to get a value that depends on the value of \code{which}.
(See \code{\link[=par]{par()}} for more on specifying \code{pch}.)}

\item{bg}{the colour to be used for plot symbol interior, for \code{pch}
values that distinguish between the interior of the symbol and the
border, e.g. for \code{pch=21}.}

\item{eos}{a character value indicating the equation of state to use
if \code{which="TS"}.  This must be \code{"gsw"} (the default) or \code{"unesco"};
see \code{\link[oce:plotTS]{oce::plotTS()}}.}

\item{mapControl}{a list that permits particular control of the \code{which="map"}
case.  If provided, it may contain elements named \code{bathymetry} (which
has the same effect as the parameter \code{bathymetry}), \code{colLand}
(which indicates the colour of the land), and \code{projection} (which
may be \code{FALSE}, meaning to plot longitude and latitude on rectilinear axes,
\code{TRUE}, meaning to plot with \code{\link[oce:mapPlot]{oce::mapPlot()}}, using Mollweide projection that
is suitable mainly for world-scale views, or a character value that will be
supplied to \code{\link[oce:mapPlot]{oce::mapPlot()}}.  If a projection is used, then the positions
of the Argo floats are plotted with \code{\link[oce:mapPoints]{oce::mapPoints()}}, rather than with
\code{\link[=points]{points()}}, and if the user wishes to locate points with mouse clicks,
then \code{\link[oce:mapLocator]{oce::mapLocator()}} must be used instead of \code{\link[=locator]{locator()}}.  If \code{bathymetry}
is not contained in \code{mapControl}, it defaults to \code{FALSE}, and if \code{projection}
is not supplied, it defaults to \code{FALSE}.  Note that \code{mapControl} takes
precedence over the \code{bathymetry} argument, if both are provided.
Also note that, at present, bathymetry cannot be shown with map projections.}

\item{profileControl}{a list that permits control of the \code{which="profile"}
case.  If provided, it may contain elements named \code{parameter} (a character value
naming the quantity to plot on the x axis), \code{ytype} (a character value equal to
either \code{"pressure"} or \code{"sigma0"}) and \code{connect} (a logical value indicating
whether to skip across \code{NA} values if the \code{type} argument is \code{"l"}, \code{"o"},
or \code{"b"}).
If \code{profileControl} is not provided, it defaults to
\code{list(parameter="temperature", ytype="pressure", connect=FALSE)}. Alternatively,
if \code{profileControl} is missing any of the three elements, then they are
given defaults as in the previous sentence.}

\item{QCControl}{a list that permits control of the \code{which="QC"}
case.  If provided, it may contain an element named \code{parameter}, a character
value naming the quantity for which the quality-control information is
to be plotted, and an element named \code{dataStateIndicator}, a logical
value controlling whether to add a panel showing this quantity
(see Reference Table 6 of reference 1 to learn more
about what is encoded in \code{dataStateIndicator}).
If not provided, \code{QCControl} defaults to
\code{list(parameter="temperature",dataStateIndicator=FALSE)}.}

\item{summaryControl}{a list that permits control of the \code{which="summary"}.
If provided, it should contain an element named \code{items}, a character vector
naming the items to be shown.  The possible entries in this vector are
\code{"dataStateIndicator"} (see Reference Table 6 of reference 1,
for more information on this quantity), \code{"length"} (the number of levels
in the profile), \code{"deepest"} (the highest pressure recorded),
\code{"longitude"} and \code{"latitude"}. If \code{summaryControl} is not provided,
all of these will be shown.  If all the elements of \code{x} have the same
\code{ID}, then the top panel will have ticks on its top axis, indicating
the \code{cycle}.}

\item{TSControl}{a list that permits control of the \code{which="TS"}
case, and is ignored for the other cases. If \code{TSControl} is
supplied, then other arguments that normally control plots
are ignored.  \code{TSControl} may have elements named
\code{drawByCycle}, \code{cex}, \code{col}, \code{pch}, \verb{lty, }lwd\code{and}type\verb{.  The first of these is a logical value indicating whether to plot individual cycles with different aesthetic characteristics, and the other elements describe those characteristics in the usual way.  By default, }type\code{is}"p"\verb{, and the point characteristics are given by the other parameters, which are passed to [rep()] to have one value per cycle.  For example, }TSControl=list(drawByCycle=TRUE,col=1:2,type="l")` indicates
to draw lines for the individual cycles, with the first being
black, the second red, the third black, etc.
\strong{FIXME: THIS IS NOT CODED YET.}}

\item{debug}{an integer specifying the level of debugging.}

\item{\dots}{extra arguments passed to the plot calls that are made
within this function.}
}
\value{
None (invisible NULL).
}
\description{
The action depends on the \code{type} of the object, and
this is set up by the function that created the object;
see \dQuote{Details}. These are basic plot styles, with
somewhat limited scope for customization. Since the data with
\linkS4class{argoFloats} objects are easy to extract, users should
not find it difficult to create their own plots to meet a
particular aesthetic. See \dQuote{Examples} and Kelley et al. (2021)
for more plotting examples.
}
\details{
The various plot types are as follows.
\itemize{
\item For \code{which="map"}, a map of profile locations is created if subtype
is equal to cycles, or a rectangle highlighting the trajectory of a
float ID is created when subtype is equal to trajectories. This
only works if the \code{type} is \code{"index"} (meaning that \code{x} was created
by \code{\link[=getIndex]{getIndex()}} or a subset of such an object, created with
\code{\link[=subset,argoFloats-method]{subset,argoFloats-method()}}), or \code{argos} (meaning that
\code{x} was created with \code{\link[=readProfiles]{readProfiles()}}.  The plot range is
auto-selected.  If the \code{ocedata} package
is available, then its \code{coastlineWorldFine} dataset is used to draw
a coastline (which will be visible only if the plot region
is large enough); otherwise, if the \code{oce} package is available, then its
\code{coastlineWorld} dataset is used.
The \code{bathymetry} argument controls whether (and how) to draw a map underlay
that shows water depth. There are three possible values for \code{bathymetry}:
\enumerate{
\item \code{FALSE} (the default, via \code{\link[=argoDefaultBathymetry]{argoDefaultBathymetry()}}), meaning not to draw bathymetry;
\item \code{TRUE}, meaning to draw bathymetry as an
image, using data downloaded with \code{\link[oce:download.topo]{oce::download.topo()}}.
Example 4 illustrates this, and also shows how to adjust
the margins after the plot, in case there is a need to add
extra graphical elements using \code{\link[=points]{points()}}, \code{\link[=lines]{lines()}}, etc.
\item A list with items controlling both the bathymetry data and its
representation in the plot (see Example 4).  Those items are:
\enumerate{
\item \code{source}, a mandatory value that is either
(a) the string \code{"auto"} (the default) to use
\code{\link[oce:download.topo]{oce::download.topo()}} to download the data
or (b) a value returned by \code{\link[oce:read.topo]{oce::read.topo()}}.
\item \code{contour}, an optional logical value (with \code{FALSE} as the default)
indicating whether to represent
bathymetry with contours (with depths of 100m, 200m, 500m shown,
along with 1km, 2km up to 10km), as opposed to an image;
\item \code{colormap}, ignored if \code{contour} is \code{TRUE},
an optional value that is either the string \code{"auto"} (the default)
for a form of GEBCO colors computed with
\code{\link[oce:oceColorsGebco]{oce::oceColorsGebco()}}, or a value computed with \code{\link[oce:colormap]{oce::colormap()}}
applied to the bathymetry data; and
\item \code{palette}, ignored if \code{contour} is \code{TRUE},
an optional logical value (with \code{TRUE} as the default)
indicating whether to draw a depth-color
palette to the right of the plot.
Note that the default value for \code{bathymetry} is set by a call
to \code{\link[=argoDefaultBathymetry]{argoDefaultBathymetry()}}, and that this second function can only handle possibilities
1 and 2 above.
}
}
\item For \code{which="profile"}, a profile plot is created, showing the variation of
some quantity with pressure or potential density anomaly, as specified by the
\code{profileControl} argument.
\item For \code{which="QC"}, two time-series panels are shown, with
time being that recorded in the individual profile in the dataset.
An additional argument named \code{parameter} must be given, to name the
quantity of interest.  The function only works if \code{x} is an
\code{\linkS4class{argoFloats}} object created with \code{\link[=readProfiles]{readProfiles()}}.
The top panel shows the percent of data flagged with codes
1 (meaning good data), 2 (probably good), 5 (changed)
or 8 (estimated), as a function of time (lower axis) and
(if all cycles are from a single Argo float)
cycle number (upper axis, with smaller font).
Thus, low values on the top panel reveal
profiles that are questionable. Note that if all of data at a given time
have flag 0, meaning not assessed, then a quality of 0 is plotted at that
time. The bottom panel shows the mean value of the parameter in question
regardless of the flag value.
\item For \code{which="summary"}, one or more time-series panels are shown
in a vertical stack.  If there is only one ID in \code{x}, then the cycle
values are indicated along the top axis of the top panel. The choice
of panels is set by the \code{summaryControl} argument.
\item For \code{which="TS"}, a TS plot is created, by calling \code{\link[=plotArgoTS]{plotArgoTS()}}
with the specified \code{x}, \code{xlim}, \code{ylim}, \code{xlab}, \code{ylab},
\code{type}, \code{cex}, \code{col}, \code{pch}, \code{bg}, \code{eos}, and \code{TSControl},
along with \code{debug-1}.  See the help for \code{\link[=plotArgoTS]{plotArgoTS()}}
for how these parameters are interpreted.
}
}
\examples{
# Example 1: map profiles in index
library(argoFloats)
data(index)
plot(index)

# Example 2: as Example 1, but narrow the margins and highlight floats
# within a circular region of diameter 100 km.
oldpar <- par(no.readonly=TRUE)
par(mar=c(2, 2, 1, 1), mgp=c(2, 0.7, 0))
plot(index)
lon <- index[["longitude"]]
lat <- index[["latitude"]]
near <- oce::geodDist(lon, lat, -77.06, 26.54) < 100
R <- subset(index, near)
points(R[["longitude"]], R[["latitude"]],
    cex=0.6, pch=20, col="red")
par(oldpar)

# Example 3: TS of a built-in data file.
f <- system.file("extdata", "SR2902204_131.nc", package="argoFloats")
a <- readProfiles(f)
oldpar <- par(no.readonly=TRUE)
par(mar=c(3.3, 3.3, 1, 1), mgp=c(2, 0.7, 0)) # wide margins for axis names
plot(a, which="TS")
par(oldpar)
\donttest{
# Example 4: map with bathymetry. Note that par(mar) is adjusted
# for the bathymetry palette, so it must be adjusted again after
# the plot(), in order to add new plot elements.
# This example specifies a coarse bathymetry dataset that is provided
# by the 'oce' package.  In typical applications, the user will use
# a finer-scale dataset, either by using bathymetry=TRUE (which
# downloads a file appropriate for the plot view), or by using
# an already-downloaded file.
data(topoWorld, package="oce")
oldpar <- par(no.readonly=TRUE)
par(mar=c(2, 2, 1, 2), mgp=c(2, 0.7, 0)) # narrow margins for a map
plot(index, bathymetry=list(source=topoWorld))
# For bathymetry plots that use images, plot() temporarily
# adds 2.75 to par("mar")[4] so the same must be done, in order
# to correctly position additional points (shown as black rings).
par(mar=par("mar") + c(0, 0, 0, 2.75))
points(index[["longitude"]], index[["latitude"]],
    cex=0.6, pch=20, col="red")
par(oldpar)

# Example 5. Simple contour version, using coarse dataset (ok on basin-scale).
# Hint: use oce::download.topo() to download high-resolution datasets to
# use instead of topoWorld.
oldpar <- par(no.readonly=TRUE)
par(mar=c(2, 2, 1, 1))
data(topoWorld, package="oce")
plot(index, bathymetry=list(source=topoWorld, contour=TRUE))
par(oldpar)

# Example 6. Customized map, sidestepping plot,argoFloats-method().
lon <- topoWorld[["longitude"]]
lat <- topoWorld[["latitude"]]
asp <- 1/cos(pi/180*mean(lat))
# Limit plot region to float region.
xlim <- range(index[["longitude"]])
ylim <- range(index[["latitude"]])
# Colourize 1km, 2km, etc, isobaths.
contour(x=lon, y=lat, z=topoWorld[["z"]], xlab="", ylab="",
    xlim=xlim, ylim=ylim, asp=asp,
    col=1:6, lwd=2, levels=-1000*1:6, drawlabels=FALSE)
# Show land
data(coastlineWorldFine, package="ocedata")
polygon(coastlineWorldFine[["longitude"]],
        coastlineWorldFine[["latitude"]], col="lightgray")
# Indicate float positions.
points(index[["longitude"]], index[["latitude"]], pch=20)


# Example 7: Temperature profile of the 131st cycle of float with ID 2902204
a <- readProfiles(system.file("extdata", "SR2902204_131.nc", package="argoFloats"))
oldpar <- par(no.readonly=TRUE)
par(mfrow=c(1, 1))
par(mgp=c(2, 0.7, 0))                  # mimic the oce::plotProfile() default
par(mar=c(1,3.5,3.5,2))                # mimic the oce::plotProfile() default
plot(a, which="profile")
par(oldpar)

# Example 8: As Example 7, but showing temperature dependence on potential density anomaly.
a <- readProfiles(system.file("extdata", "SR2902204_131.nc", package="argoFloats"))
oldpar <- par(no.readonly=TRUE)
par(mgp=c(2, 0.7, 0))                  # mimic the oce::plotProfile() default
par(mar=c(1,3.5,3.5,2))                # mimic the oce::plotProfile() default
plot(a, which="profile", profileControl=list(parameter="temperature", ytype="sigma0"))
par(oldpar)

}

}
\references{
\enumerate{
\item Carval, Thierry, Bob Keeley, Yasushi Takatsuki, Takashi Yoshida, Stephen Loch,
Claudia Schmid, and Roger Goldsmith. Argo User's Manual V3.3. Ifremer, 2019.
\code{doi:10.13155/29825}
\item Kelley, D. E., Harbin, J., & Richards, C. (2021). argoFloats: An R package for analyzing
Argo data. Frontiers in Marine Science, (8), 636922.
\doi{10.3389/fmars.2021.635922}
}
}
\author{
Dan Kelley and Jaimie Harbin
}
