% Generated by roxygen2 (4.0.1): do not edit by hand
\name{parse.args}
\alias{parse.args}
\title{Parse arguments with a parser.}
\usage{
parse.args(parser, argv = commandArgs(trailingOnly = TRUE))
}
\arguments{
\item{parser}{an arg.parser object}

\item{argv}{a character vector to parse (arguments and values should
already be split by whitespace)}
}
\value{
a list with argument values
}
\description{
This function uses an arg.parser object to parse command line arguments or a
character vector.
}
\examples{
p <- arg.parser('pi');
p <- add.argument(p, "--digits",
  help="number of significant digits to print", default=7);

\dontrun{
# if arguments are passed from the command line,
# then we would use the following:
argv <- parse.args(p);
}

# for testing purposes, we can pass a character vector:
argv <- parse.args(p, c("-d", "30"));

# now, the script runs based on the passed arguments
digits <- if (argv$digits > 22) 22 else argv$digits;
print(pi, digits=digits);

\dontrun{
# we can also save an argument list for later use
saveRDS(argv, "arguments.rds");

# to use the saved arguments, use the --opts argument at the command line
#$ script --opts arguments.rds
}
}

