% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ari_stitch.R
\name{ari_stitch}
\alias{ari_stitch}
\title{Create a video from images and audio}
\usage{
ari_stitch(images, audio, output = "output.mp4")
}
\arguments{
\item{images}{A vector of paths to images.}

\item{audio}{A list of \code{Wave}s from tuneR.}

\item{output}{A path to the video file which will be created.}
}
\description{
Given a vector of paths to images (preferably \code{.jpg}s
or \code{.png}s) and a flat list of \code{\link[tuneR]{Wave}}s of equal
length this function will create an \code{.mp4} video file where each image 
is shown with its corresponding audio. Take a look at the
\code{\link[tuneR]{readWave}} function if you want to import your audio 
files into R. Please be sure that all images have the same dimensions.
}
\details{
This function uses \href{https://ffmpeg.org/}{FFmpeg}
which you should be sure is installed before using this function. If running
\code{Sys.which("ffmpeg")} in your R console returns an empty string after
installing FFmpeg then you should set the path to FFmpeg on you computer to
an environmental variable using \code{Sys.setenv(ffmpeg = "path/to/ffmpeg")}.
The environmental variable will always override the result of
\code{Sys.which("ffmpeg")}.
}
\examples{
\dontrun{

library(tuneR)
library(purrr)

slides <- c("intro.jpeg", "equations.jpeg", "questions.jpeg")
sound <- map(c("rec1.wav", "rec2.wav", "rec3.wav"), readWave)

ari_stitch(slides, sound)

}
}
