% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mix_opt.R
\name{mixIP}
\alias{mixIP}
\title{Estimate mixture proportions of a mixture model by Interior Point method}
\usage{
mixIP(matrix_lik, prior, pi_init = NULL, control = list(),
  weights = NULL)
}
\arguments{
\item{matrix_lik, }{a n by k matrix with (j,k)th element equal to \eqn{f_k(x_j)}.}

\item{prior, }{a k vector of the parameters of the Dirichlet prior on \eqn{\pi}. Recommended to be rep(1,k)}

\item{pi_init, }{the initial value of \eqn{\pi} to use. If not specified defaults to (1/k,...,1/k).}

\item{control}{A list of control parameters to be passed to REBayes::KWDual}

\item{weights}{weights to be assigned to the observations (an n vector)}
}
\value{
A list, including the estimates (pihat), the log likelihood for each interation (B)
and a flag to indicate convergence
}
\description{
Given the individual component likelihoods for a mixture model, estimates the mixture proportions.
}
\details{
Optimizes \deqn{L(pi)= sum_j w_j log(sum_k pi_k f_{jk}) + h(pi)} 
subject to pi_k non-negative and sum_k pi_k = 1. Here \deqn{h(pi)} is
a penalty function h(pi) = sum_k (prior_k-1) log pi_k.
Calls REBayes::KWDual in the REBayes package, which is in turn a wrapper to the mosek 
convex optimization software. So REBayes must be installed to use this. 
Used by the ash main function; there is no need for a user to call this 
function separately, but it is exported for convenience.
}
