test.is_uk_car_licence.a_character_vector.returns_true_when_string_contains_a_uk_car_licence <- function()
{
  x <- c(
    #1903 to 1931
    "A 1", "AA 9999",                       #ok
    "A 01",                                 #zero prefix on number
    "S0", "G0", "RG0", "LM0",               #ok, special plates
    #1931 to 1963
    "AAA 1", "AAA 999",                     #ok
    "III 1", "QQQ 1", "ZZZ 1",              #disallowed letters
    "AAA 01",                               #zero prefix on number
    #1931 to 1963 alt
    "1 AAA", "9999 AAA",                    #ok
    "1 III", "1 QQQ", "1 ZZZ",              #disallowed letters
    "01 AAA",                               #zero prefix on number
    #1963 to 1982
    "AAA 1A", "AAA 999A",                   #ok
    "AAA 1I", "AAA 1O", "AAA 1Q",           #disallowed letters
    "AAA 1U", "AAA 1Z", 
    "AAA 01A",                              #zero prefix on number
    #1982 to 2001
    "A1 AAA", "A999 AAA",                   #ok    
    "I1 AAA", "O1 AAA",                     #disallowed letters
    "U1 AAA", "Z1 AAA",
    "A01 AAA",                              #zero prefix on number
    #2001 to 2051
    "AA00 AAA", "AA99 AAA",                 #ok
    "II00 AAA", "QQ00 AAA", "ZZ00 AAA",     #disallowed letters
    "AA00 III", "AA00 QQQ"
  )
  expected <- c(
    TRUE, TRUE, 
    FALSE,
    TRUE, TRUE, TRUE, TRUE,
    TRUE, TRUE,
    FALSE, FALSE, FALSE,
    FALSE,
    TRUE, TRUE,
    FALSE, FALSE, FALSE,
    FALSE,
    TRUE, TRUE,
    FALSE, FALSE, FALSE,
    FALSE, FALSE,
    FALSE,
    TRUE, TRUE,
    FALSE, FALSE,
    FALSE, FALSE,
    FALSE,
    TRUE, TRUE,
    FALSE, FALSE, FALSE,
    FALSE, FALSE
  )
  names(expected) <- x
  checkEquals(
    expected,
    is_uk_car_licence(x)
  )
} 


test.is_uk_national_insurance_number.a_character_vector.returns_true_when_string_contains_a_uk_national_insurance_number <- function()
{
  x <- c(
    "AA 00 00 00 A", "AA 00 00 00", "AA000000A",                #ok
    "ZZ 99 99 99 M", "ZZ 99 99 99", "ZZ999999M",                
    "DA 00 00 00", "FA 00 00 00", "IA 00 00 00",                #bad first letter
    "QA 00 00 00", "UA 00 00 00", "VA 00 00 00",
    "AD 00 00 00", "AF 00 00 00", "AI 00 00 00", "AO 00 00 00", #bad second letter
    "AQ 00 00 00", "AU 00 00 00", "AV 00 00 00",
    "AA 00 00 00 E", "AA 00 00 00 G", "AA 00 00 00 H",          #bad final letter
    "AA 00 00 00 I", "AA 00 00 00 J", "AA 00 00 00 K",
    "AA 00 00 00 L", "AA 00 00 00 N", "AA 00 00 00 O",
    "AA 00 00 00 P", "AA 00 00 00 Q", "AA 00 00 00 R",
    "AA 00 00 00 S", "AA 00 00 00 T", "AA 00 00 00 U",
    "AA 00 00 00 V", "AA 00 00 00 W", "AA 00 00 00 X",
    "AA 00 00 00 Y", "AA 00 00 00 Z"    
  )
  expected <- rep(c(TRUE, FALSE), times = c(6, 33))
  names(expected) <- x
  checkEquals(
    expected,
    is_uk_national_insurance_number(x)
  )
} 


test.is_uk_postcode.a_character_vector.returns_true_when_string_contains_a_uk_postcode <- function()
{
  x <- c(
    "SW1A 1AA", "SK11 9DW", "M34FP",  #ok
    "Le45ns", "TS25 2BZ", "gir 0aa",
    "Q1 1AA", "V1 1AA", "X1 1AA",     #bad first letter in area
    "A01 1AA", "A100 1AA", "A1 10AA", #bad numbers
    "A1 1CA", "A1 1IA", "A1 1KA",     #bad letter in district
    "A1 1MA", "A1 1OA", "A1 1VA"
  )
  expected <- rep(c(TRUE, FALSE), times = c(6, 12))
  names(expected) <- x
  checkEquals(
    expected,
    is_uk_postcode(x)
  )
} 


test.is_uk_telephone_number.a_character_vector.returns_true_when_string_contains_a_uk_telephone_number <- function()
{
  x <- c(
    "+442001234567", "02011234567", #ok new style city
    "02031234567", "02071234567",
    "02081234567", "02301234567",
    "02311234567", "02381234567",
    "02391234567", "02401234567",
    "02411234567", "02471234567",
    "02801234567", "02811234567",
    "02821234567", "02831234567",
    "02841234567", "02861234567",
    "02871234567", "02881234567",
    "02891234567", "02901234567",
    "02911234567", "02921234567",
    "01130123456", "01131123456",  #ok old style city
    "01132123456", "01133123456",
    "01134123456", "01138123456",
    "01140123456", "01141123456",
    "01142123456", "01143123456",
    "01144123456", "01160123456",
    "01161123456", "01162123456",
    "01163123456", "01164123456",
    "01150123456", "01151123456",
    "01152123456", "01157123456",
    "01158123456", "01159123456",
    "01170123456", "01171123456",
    "01172123456", "01173123456",
    "01179123456", "01180123456",
    "01181123456", "01183123456",
    "01184123456", "01189123456",
    "01210123456", "01211123456",
    "01212123456", "01213123456",
    "01214123456", "01215123456",
    "01216123456", "01217123456",
    "01310123456", "01311123456",
    "01312123456", "01313123456",
    "01314123456", "01315123456",
    "01316123456", "01317123456",
    "01318123456", "01411234567",
    "01511234567", "01911234567",
    "01610123456", "01611123456",
    "01612123456", "01613123456",
    "01614123456", "01616123456",
    "01617123456", "01618123456",
    "01619123456", 
    "01200123456", "01202123456",                      #ok regional (4+6)
    "01204123456", "01205123456",
    "01206123456", "01207123456",
    "01208123456", "01209123456",
    "01223123456", "01224123456",
    "01225123456", "01226123456",
    "01227123456", "01228123456",
    "01229123456", "01233123456",
    "01234123456", "01235123456",
    "01236123456", "01237123456",
    "01239123456", "01241123456",
    "01242123456", "01243123456",
    "01244123456", "01245123456",
    "01246123456", "01248123456",
    "01249123456", "01250123456",
    "01252123456", "01253123456",
    "01254123456", "01255123456",
    "01256123456", "01257123456",
    "01258123456", "01259123456",
    "01280123456", "01282123456",
    "01283123456", "01284123456",
    "01285123456", "01286123456",
    "01287123456", "01288123456",
    "01289123456", "01260123456",
    "01261123456", "01262123456",
    "01263123456", "01264123456",
    "01267123456", "01268123456",
    "01269123456", "01270123456",
    "01271123456", "01273123456",
    "01274123456", "01275123456",
    "01276123456", "01277123456",
    "01278123456", "01279123456",
    "01291234567", "01301234567",
    "01320123456", "01322123456",
    "01323123456", "01324123456",
    "01325123456", "01326123456",
    "01327123456", "01328123456",
    "01329123456", "01350123456",
    "01352123456", "01353123456",
    "01354123456", "01355123456",
    "01356123456", "01357123456",
    "01358123456", "01359123456",
    "01330123456", "01332123456",
    "01333123456", "01334123456",
    "01335123456", "01337123456",
    "01339123456", "01340123456",
    "01341123456", "01342123456",
    "01343123456", "01344123456",
    "01346123456", "01347123456",
    "01348123456", "01349123456",
    "01360123456", "01361123456",
    "01362123456", "01363123456",
    "01364123456", "01366123456",
    "01367123456", "01368123456",
    "01369123456", "01380123456",
    "01381123456", "01382123456",
    "01383123456", "01384123456",
    "01386123456", "01387123456",
    "01388123456", "01389123456",
    "01371123456", "01372123456",
    "01373123456", "01375123456",
    "01376123456", "01377123456",
    "01379123456", "01392123456",
    "01394123456", "01395123456",
    "01397123456", "01398123456",
    "01400123456", "01403123456",
    "01404123456", "01405123456",
    "01406123456", "01407123456",
    "01408123456", "01409123456",
    "01420123456", "01422123456",
    "01423123456", "01424123456",
    "01425123456", "01427123456",
    "01428123456", "01429123456",
    "01431234567", "01471234567",
    "01440123456", "01442123456",
    "01443123456", "01444123456",
    "01445123456", "01446123456",
    "01449123456", "01450123456",
    "01451123456", "01452123456",
    "01453123456", "01454123456",
    "01455123456", "01456123456",
    "01457123456", "01458123456",
    "01460123456", "01461123456",
    "01462123456", "01463123456",
    "01464123456", "01465123456",
    "01466123456", "01467123456",
    "01469123456", "01490123456",
    "01491123456", "01492123456",
    "01493123456", "01494123456",
    "01495123456", "01496123456",
    "01497123456", "01499123456",
    "01501123456", "01502123456",
    "01503123456", "01505123456",
    "01506123456", "01507123456",
    "01508123456", "01509123456",
    "01520123456", "01522123456",
    "01524123456", "01525123456",
    "01526123456", "01527123456",
    "01528123456", "01529123456",
    "01530123456", "01531123456",
    "01534123456", "01535123456",
    "01536123456", "01538123456",
    "01539123456", "01540123456",
    "01542123456", "01543123456",
    "01543123456", "01545123456",
    "01546123456", "01547123456",
    "01548123456", "01549123456",
    "01550123456", "01553123456",
    "01554123456", "01555123456",
    "01556123456", "01557123456",
    "01558123456", "01559123456",
    "01561234567", "01570123456",
    "01571123456", "01572123456",
    "01573123456", "01575123456",
    "01576123456", "01577123456",
    "01578123456", "01579123456",
    "01580123456", "01581123456",
    "01581223456", "01583123456",
    "01581423456", "01586123456",
    "01588123456", "01590123456",
    "01591123456", "01592123456",
    "01593123456", "01594123456",
    "01595123456", "01597123456",
    "01598123456", "01599123456",
    "01600123456", "01603123456",
    "01604123456", "01606123456",
    "01608123456", "01609123456",
    "01620123456", "01621123456",
    "01622123456", "01623123456",
    "01624123456", "01625123456",
    "01626123456", "01628123456",
    "01629123456", "01630123456",
    "01631123456", "01633123456",
    "01634123456", "01635123456",
    "01636123456", "01637123456",
    "01638123456", "01639123456",
    "01680123456", "01681123456",
    "01683123456", "01684123456",
    "01685123456", "01686123456",
    "01687123456", "01688123456",
    "01689123456", "01641123456",
    "01642123456", "01643123456",
    "01644123456", "01646123456",
    "01647123456", "01650123456",
    "01651123456", "01652123456",
    "01653123456", "01654123456",
    "01655123456", "01656123456",
    "01659123456", "01661123456",
    "01663123456", "01664123456",
    "01665123456", "01666123456",
    "01667123456", "01668123456",
    "01669123456", "01670123456",
    "01671123456", "01672123456",
    "01673123456", "01674123456",
    "01675123456", "01676123456",
    "01677123456", "01678123456",
    "01690123456", "01691123456",
    "01692123456", "01694123456",
    "01695123456", "01697123456",
    "01698123456", "01700123456",
    "01702123456", "01704123456",
    "01706123456", "01707123456",
    "01708123456", "01709123456",
    "01721234567", "01730123456",
    "01732123456", "01733123456",
    "01736123456", "01737123456",
    "01738123456", "01740123456",
    "01743123456", "01744123456",
    "01745123456", "01746123456",
    "01747123456", "01748123456",
    "01749123456", "01750123456",
    "01751123456", "01752123456",
    "01753123456", "01754123456",
    "01756123456", "01757123456",
    "01758123456", "01759123456",
    "01760123456", "01761123456",
    "01763123456", "01764123456",
    "01765123456", "01766123456",
    "01767123456", "01768123456",
    "01769123456", "01770123456",
    "01771123456", "01772123456",
    "01773123456", "01775123456",
    "01776123456", "01777123456",
    "01778123456", "01779123456",
    "01780123456", "01782123456",
    "01784123456", "01785123456",
    "01786123456", "01787123456",
    "01788123456", "01789123456",
    "01790123456", "01792123456",
    "01793123456", "01794123456",
    "01795123456", "01796123456",
    "01797123456", "01798123456",
    "01799123456", "01803123456",
    "01805123456", "01806123456",
    "01807123456", "01808123456",
    "01809123456", "01821123456",
    "01822123456", "01823123456",
    "01824123456", "01825123456",
    "01827123456", "01828123456",
    "01829123456", "01830123456",
    "01832123456", "01833123456",
    "01834123456", "01835123456",
    "01837123456", "01838123456",
    "01840123456", "01841123456",
    "01842123456", "01843123456",
    "01844123456", "01845123456",
    "01847123456", "01848123456",
    "01851123456", "01852123456",
    "01854123456", "01855123456",
    "01856123456", "01857123456",
    "01858123456", "01859123456",
    "01862123456", "01863123456",
    "01864123456", "01865123456",
    "01866123456", "01869123456",
    "01871234567", "01880123456",
    "01882123456", "01883123456",
    "01884123456", "01885123456",
    "01886123456", "01887123456",
    "01888123456", "01889123456",
    "01890123456", "01892123456",
    "01895123456", "01896123456",
    "01899123456", "01900123456",
    "01902123456", "01903123456",
    "01904123456", "01905123456",
    "01908123456", "01909123456",
    "01920123456", "01922123456",
    "01923123456", "01924123456",
    "01925123456", "01926123456",
    "01928123456", "01929123456",
    "01931123456", "01932123456",
    "01933123456", "01934123456",
    "01935123456", "01937123456",
    "01938123456", "01939123456",
    "01942123456", "01943123456",
    "01944123456", "01945123456",
    "01946123456", "01947123456",
    "01948123456", "01949123456",
    "01950123456", "01951123456",
    "01952123456", "01953123456",
    "01953123456", "01955123456",
    "01957123456", "01959123456",
    "01962123456", "01963123456",
    "01964123456", "01967123456",
    "01968123456", "01969123456",
    "01970123456", "01971123456",
    "01972123456", "01974123456",
    "01975123456", "01977123456",
    "01978123456", "01981234567",
    "01992123456", "01993123456",
    "01994123456", "01995123456",
    "01997123456", 
    "0120461123", "0120462123",                      #ok regional (6+3)
    "0120463123", "0120464123",
    "0120872123", "0120873123",
    "0120874123", "0120875123",
    "0120876123", "0120877123",
    "0120878123", "0120879123",
    "0125451123", "0125452123",
    "0125451323", "0125454123",
    "0125455123", "0125456123",
    "0125457123", "0125459123",
    "0127621234", "0127631123",
    "0127632123", "0127633123",
    "0127634123", "0127635123",
    "0127636123", "0127637123",
    "0127638123", "0127661123",
    "0127661123", "0127661123",
    "0127661123", "0127661123",
    "0127661123", "0129720123",
    "0129721123", "0129722123",
    "0129723123", "0129724123",
    "0129732123", "0129733123",
    "0129734123", "0129735123",
    "0129822123", "0129823123",
    "0129824123", "0129825123",
    "0129826123", "0129827123",
    "0129828123", "0129870123",
    "0129871123", "0129872123",
    "0129873123", "0129874123",
    "0129877123", "0129878123",
    "0129879123", "0129883123",
    "0129884123", "0129885123",
    "0136382123", "0136383123",
    "0136384123", "0136385123",
    "0136472123", "0136473123",
    "0138470123", "0138474123",
    "0138474123", "0138476123",
    "0138477123", "0138478123",
    "0138479123", "0138640123",
    "0138641123", "0138645123",
    "0138647123", "0138648123",
    "0138649123", "0140441123",
    "0140442123", "0140443123",
    "0140444123", "0140445123",
    "0140446123", "0140447123",
    "0142022123", "0142023123",
    "0142081234", "0146030123",
    "0146052123", "0146053123",
    "0146054123", "0146055123",
    "0146057123", "0146061123",
    "0146062123", "0146063123",
    "0146064123", "0146065123",
    "0146066123", "0146067123",
    "0146068123", "0146072123",
    "0146073123", "0146074123",
    "0146075123", "0146076123",
    "0146077123", "0146078123",
    "0146140123", "0148052123",
    "0148871123", "0148872123",
    "0148873123", "0152432123",
    "0152432323", "0152434123",
    "0152432523", "0152436123",
    "0152432723", "0152439123",
    "0152461234", "0152761234",
    "0156260123", "0156266123",
    "0156267123", "0156268123",
    "0156269123", "0156686123",
    "0160641234", "0160674123",
    "0160675123", "0160676123",
    "0160677123", "0160679123",
    "0162955123", "0162956123",
    "0162957123", "0163531234",
    "0163541234", "0164724123",
    "0164761123", "0165950123",
    "0165958123", "0165966123",
    "0165967123", "0165974123",
    "0169550123", "0169551123",
    "0169552123", "0169553123",
    "0169554123", "0172661123",
    "0172663123", "0172664123",
    "0172665123", "0172666123",
    "0172667123", "0172668123",
    "0172669123", "0172670123",
    "0172671123", "0172672123",
    "0172673123", "0172674123",
    "0172675123", "0172676123",
    "0172677123", "0174421234",
    "0175020123", "0175021123",
    "0175022123", "0175023123",
    "0175032123", "0175042123",
    "0175052123", "0175062123",
    "0175082123", "0175076123",
    "0182751234", "0182761234",
    "0183752123", "0183753123",
    "0183754123", "0183755123",
    "0183782123", "0183783123",
    "0183789123", "0188432123",
    "0188433123", "0188434123",
    "0188435123", "0188438123",
    "0190061123", "0190062123",
    "0190063123", "0190064123",
    "0190065123", "0190066123",
    "0190067123", "0190068123",
    "0190085123", "0190521234",
    "0193583123", "0194661123",
    "0194662123", "0194663123",
    "0194664123", "0194665123",
    "0194666123", "0194667123",
    "0194668123", "0194920123",
    "0194921123", "0194981123",
    "0196323123", "0196331123",
    "0196332123", "0196333123",
    "0196334123", "0199561123",
    "0176888212", "0176888412",                      #ok special regional
    "0176888412", "0176888612",
    "0176888712", "0176888812",
    "0169772123", "0169773123",
    "07112345678", "07212345678",                      #ok mobiles
    "07312345678", "07412345678",
    "07112345678", "07511234567",
    "07531234567", "07541234567",
    "07551234567", "07561234567",
    "07571234567", "07581234567",
    "07591234567", "07501123456",
    "07520123456", "07624123456",
    "07711234567", "07801234567",
    "07901234567", 
    "07600123456", "07601123456",                      #ok pagers
    "07602123456", "07623123456",
    "07625123456", "07626123456",
    "07640123456", "07641123456",
    "07643123456", "07644123456",
    "07654123456", "07659123456",
    "07660123456", "07661123456",
    "07662123456", "07663123456",
    "07666123456", "07669123456",
    "07677123456", "07681123456",
    "07693123456", "07699123456",
    "08001111", "0800123456",        #ok free
    "08001234567", "08081234567", 
    "0500123456",
    "07811234567", "07821234567",    #ok premium
    "07831234567", "09011234567",
    "09111234567", "09811234567",
    "09821234567", "09831234567",    
    "08421234567", "08431234567",    #ok shared
    "08441234567", "08451234567",
    "08701234567",
    "07012345678",                   #ok personal
    "05612345678",                   #ok VoIP
    "05512345678", "03012345678",    #ok UAN
    "03312345678", "03412345678", 
    "03712345678",
    "+452001234567", "442001234567", #bad country code
    "020012345678", "071123456789",  #too many digits
    "0200123456", "0711234567",      #not enough digits
    "02112345678", "02212345678",    #bad new style city
    "02512345678", "02612345678",
    "02712345678",
    "01711234567", "01811234567",    #bad standard city
    "01201123456", "01421123456",    #bad regional (4+6) (really non-exhaustive) 
    "0120465123", "0162789123",      #bad regional (6+3) (really non-exhaustive)
    "0176888112", "0169770123",      #bad special regional
    "07509123456", "07524123456",    #bad mobiles
    "07700123456", "07781123456",
    "07797123456", "07829123456",                      
    "07839123456", "07911123456",
    "07924123456", "07937123456",                      
    "07611234567", "07611234567",    #bad pagers
    "07631234567",                               
    "08741234567", "08751234567",    #bad premium
    "08761234567", "08771234567",
    "08781234567", "08791234567",
    "09212345678", "09312345678",
    "09212345678", "09312345678",
    "09412345678", "09512345678",
    "09612345678", "09712345678",
    "09912345678", "09801234567",
    "09841234567", "09851234567",
    "09861234567", "09871234567",
    "09881234567", "09891234567",
    "08401234567", "08411234567",    #bad shared
    "08461234567", "08471234567",
    "08481234567", "08491234567",
    "08410234567", "08411234567",    #bad personal
    "08460234567", "08470234567",                     
    "08480234567", "08490234567",                     
    "03112345678", "03212345678",    #bad UAN
    "03812345678", "03912345678"
  )
  expected <- rep(c(TRUE, FALSE), times = c(884, 70))
  names(expected) <- x
  checkEquals(
    expected,
    is_uk_telephone_number(x)
  )
} 
