% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/assert-is-type.R, R/is-type.R
\name{assert_is_S4}
\alias{assert_is_S4}
\alias{assert_is_s4}
\alias{is_S4}
\alias{is_s4}
\title{Is the input an S4 object?}
\usage{
assert_is_S4(x)

assert_is_s4(x)

is_s4(x, .xname = get_name_in_parent(x))

is_S4(x, .xname = get_name_in_parent(x))
}
\arguments{
\item{x}{Input to check.}

\item{.xname}{Not intended to be used directly.}
}
\value{
\code{is_S4} wraps \code{isS4}, providing more information on
failure.  \code{assert_is_S4} returns nothing but throws an error if
\code{is_S4} returns \code{FALSE}.
}
\description{
Checks to see if the input is an S4 object.
}
\examples{
assert_is_s4(getClass("MethodDefinition"))
#These examples should fail.
dont_stop(assert_is_s4(1:10))
}
\seealso{
\code{\link[base]{isS4}}.
}

