% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/is-reflection.R
\name{is_package_current}
\alias{is_package_current}
\title{Is the installed version of a package current?}
\usage{
is_package_current(x, lib.loc = .libPaths(), repos = getOption("repos"),
  type = getOption("pkgType"))
}
\arguments{
\item{x}{A string giving a package name.}

\item{lib.loc}{A character vector of paths to local package libraries.}

\item{repos}{A character vector of URLs to repositories to check for new
package versions.}

\item{type}{Check the repository for source or binary packages?}
}
\value{
The \code{is_*} functions return \code{TRUE} or \code{FALSE}.
The \code{assert_*} functions throw an error in the event of failure.
}
\description{
Checks to see if the installed version of a package is current.
}
\examples{
\donttest{
# This test is marked "dont-test" since it involves a connection to
# repositories which is potentially long running.
is_package_current("assertive")
}
}
\seealso{
\code{\link[utils]{old.packages}}, on which this is based, which
has advanced usage features.
}

