% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-rec.R
\name{plot_rec}
\alias{plot_rec}
\title{Plot recruitment.}
\usage{
plot_rec(data, ex_data, ncol = 7)
}
\arguments{
\item{data}{Dataframe with information about ssb and recruits.
This is created from atlantis output files YOY.txt and SSB.txt
(Usually output[...]YOY.txt' & 'output[...]SSB.txt') using
\code{\link{load_rec}}.}

\item{ex_data}{Dataframe to compare the atlantis run with.}

\item{ncol}{Number of columns in multipanel plot. Default is \code{7}.}
}
\value{
ggplot2 object
}
\description{
Plot recruitment.
}
\examples{
\dontrun{
d <- system.file("extdata", "setas-model-new-becdev", package = "atlantistools")
ex_data <- read.csv(file.path(d, "setas-ssb-rec.csv"), stringsAsFactors = FALSE)
plot_rec(preprocess_setas$ssb_rec, ex_data)
}
}
\seealso{
Other plot functions: \code{\link{plot_bar}},
  \code{\link{plot_boxes}},
  \code{\link{plot_diet_bec_dev}}, \code{\link{plot_diet}},
  \code{\link{plot_line}}, \code{\link{plot_species}}
}
