% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{ebird_taxonomy}
\alias{ebird_taxonomy}
\title{eBird Taxonomy}
\format{
A data frame with eight variables and 16,248 rows:
\itemize{
\item \code{scientific_name}: scientific name.
\item \code{common_name}: common name, defaults to English, but different languages
can be selected using the \code{locale} parameter.
\item \code{species_code}: a unique alphanumeric code identifying each species.
\item \code{category}: whether the entry is for a species or another
field-identifiable taxon, such as \code{spuh}, \code{slash}, \code{hybrid}, etc.
\item \code{taxon_order}: numeric value used to sort rows in taxonomic order.
\item \code{order}: the scientific name of the order that the species belongs to.
\item \code{family}: the scientific name of the family that the species belongs to.
\item \code{report_as}: for taxa that can be resolved to true species (i.e. species,
subspecies, and recognizable forms), this field links to the corresponding
species code. For taxa that can't be resolved, this field is \code{NA}.
}

For further details, see \url{https://support.ebird.org/support/solutions/articles/48000837816-the-ebird-taxonomy}
}
\usage{
ebird_taxonomy
}
\description{
A simplified version of the taxonomy used by eBird. Includes proper species
as well as various other categories such as \code{spuh} (e.g. \emph{duck sp.}) and
\emph{slash} (e.g. \emph{American Black Duck/Mallard}). This taxonomy is based on the
Clements Checklist, which is updated annually, typically in the late summer.
Non-ASCII characters (e.g. those with accents) have been converted to ASCII
equivalents in this data frame.
}
\seealso{
Other data: 
\code{\link{bcr_codes}},
\code{\link{ebird_states}},
\code{\link{valid_protocols}}
}
\concept{data}
\keyword{datasets}
