% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ECM.fit.R
\name{MFA_ECM}
\alias{MFA_ECM}
\title{ECM-Based MFA Estimation}
\usage{
MFA_ECM(
  Y,
  gmin = 1,
  gmax = 10,
  qmin = 1,
  qmax = NULL,
  eta = 0.005,
  itmax = 500,
  nkmeans = 5,
  nrandom = 5,
  tol = 1e-05,
  conv_measure = "diff",
  varimax = FALSE
)
}
\arguments{
\item{Y}{An \emph{n} by \emph{p} data matrix, where \emph{n} is the number of observations and \emph{p} is the number of dimensions of the data.}

\item{gmin}{The smallest number of components for which an MFA model will be fitted.}

\item{gmax}{The largest number of components for which an MFA model will be fitted.}

\item{qmin}{The smallest number of factors with which an MFA model will be fitted.}

\item{qmax}{The largest number of factors with which an MFA model will be fitted. Must obey the Ledermann bound.}

\item{eta}{The smallest possible entry in any of the error matrices \emph{D_i} \insertCite{Jian-HuaZhao2008FMEf}{autoMFA}.}

\item{itmax}{The maximum number of ECM iterations allowed for the estimation of each MFA model.}

\item{nkmeans}{The number of times the \emph{k}-means algorithm will be used to initialise models for each combination of \emph{g} and \emph{q}.}

\item{nrandom}{The number of randomly initialised models that will be used for each combination of g and q.}

\item{tol}{The ECM algorithm terminates if the measure of convergence falls below this value.}

\item{conv_measure}{The convergence criterion of the ECM algorithm. The default \code{'diff'} stops the ECM iterations if |l^{(k+1)} - l^{(k)}| < \code{tol} where l^{(k)} is the log-likelihood at the \emph{k}th ECM iteration. If \code{'ratio'}, then the convergence of the ECM iterations is measured using |(l^{(k+1)} - l^{(k)})/l^{(k+1)}|.}

\item{varimax}{Boolean indicating whether the output factor loading matrices should be constrained
using varimax rotation or not.}
}
\value{
A list containing the following elements:
\itemize{
\item{\code{model}:}{ A list specifying the final MFA model. This contains: \itemize{
\item{\code{B}:}{ A \emph{p} by \emph{p} by \emph{q} array containing the factor loading matrices for each component.}
\item{\code{D}:}{ A \emph{p} by \emph{p} by \emph{g} array of error variance matrices.}
\item{\code{mu}:}{  A \emph{p} by \emph{g} array containing the mean of each cluster.}
\item{\code{pivec}:}{ A 1 by \emph{g} vector containing the mixing
proportions for each FA in the mixture.}
\item{\code{numFactors}:}{ A 1 by \emph{g} vector containing the number of factors for each FA.}}
}
\item{\code{clustering}:}{ A list specifying the clustering produced by the final model. This contains: \itemize{
\item{\code{responsibilities}:}{ A \emph{n} by \emph{g} matrix containing the probability
that each point belongs to each FA in the mixture.}
\item{\code{allocations}:}{ A \emph{n} by 1 matrix containing which
FA in the mixture each point is assigned to based on the responsibilities.}}}
\item{\code{diagnostics}:}{ A list containing various pieces of information related to the fitting process of the algorithm. This contains: \itemize{
\item{\code{bic}:}{ The BIC of the final model.}
\item{\code{logL}:}{ The log-likelihood of the final model.}
\item{\code{times}:}{ A data frame containing the amount of time taken to fit each MFA model.}
\item{\code{totalTime}:}{ The total time taken to fit the final model.}}}
}
}
\description{
An implementation of an ECM algorithm for the MFA model which does not condition on the factors being known \insertCite{Jian-HuaZhao2008FMEf}{autoMFA}.
Performs a grid search from \code{gmin} to \code{gmax}, and \code{qmin} to \code{qmax}, respectively. The best combination of \emph{g} and \emph{q} is chosen to be the model with the minimum BIC.
}
\examples{
RNGversion('4.0.3'); set.seed(3)
MFA.fit <- MFA_ECM(autoMFA::MFA_testdata,3,3)
}
\references{
\insertRef{Jian-HuaZhao2008FMEf}{autoMFA}
}
