% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gpcm.R
\name{gpcm}
\alias{gpcm}
\alias{summary.gpcm}
\alias{print.gpcm}
\title{Estimation of The Generalized Partial Credit Model}
\usage{
gpcm(X, init_par = c(), setting = c(), method = c("fast", "novel"))

\method{summary}{gpcm}(object, ...)

\method{print}{gpcm}(x, ...)
}
\arguments{
\item{X}{Input dataset as matrix or data frame with ordinal responses (starting from 0);
rows represent individuals, columns represent items.}

\item{init_par}{a vector of initial values of the estimated parameters.}

\item{setting}{a list of the optimization control setting parameters. See \code{\link[autoRasch:autoRaschOptions]{autoRaschOptions()}.}}

\item{method}{The implementation option of log likelihood function. \code{fast} using a \code{c++} implementation and \code{novel} using an \code{R} implementation.}

\item{object}{The object of class \code{'gpcm'}.}

\item{...}{Further arguments to be passed.}

\item{x}{The object of class \code{'gpcm'}.}
}
\value{
\item{X}{   The dataset that is used for estimation.}
\item{mt_vek}{   A vector of the highest response given to items.}
\item{itemName}{   The vector of names of items (columns) in the dataset.}
\item{loglik}{   The log likelihood of the estimation.}
\item{hessian}{   The hessian matrix. Only when the \code{isHessian = TRUE}.}
\item{gamma}{   A vector of the natural logarithm of discrimination parameters of each items.}
\item{beta}{   A vector of the difficulty parameter of each items' categories (thresholds).}
\item{theta}{   A vector of the ability parameters of each individuals.}
}
\description{
This function computes the parameter estimates of a generalized partial credit model for polytomous responses
by using penalized JML estimation. Inputting a dichotomous responses to this model,
will automatically transforms the GPCM to the 2-PL model.
}
\details{
In the discrimination parameters estimation, instead of estimating the discrimination parameters (\eqn{\alpha}),
we are estimating its natural logarithm to avoid negative values, \eqn{\alpha = exp(\gamma)}.
}
\examples{
gpcm_res <- gpcm(short_poly_data)
summary(gpcm_res, par = "alpha")

}
\references{
Muraki, E. (1992). A generalized partial credit model: Application of an EM algorithm. Applied Psychological Measurement, 16(2). https://doi.org/10.1177/014662169201600206
}
\seealso{
\code{\link{pcm}}, \code{\link{gpcm}}
}
