% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.r
\name{gv.database_schema}
\alias{gv.database_schema}
\title{Generate Graphviz input text to plot database schemas}
\usage{
\method{gv}{database_schema}(x, name = NA_character_, ...)
}
\arguments{
\item{x}{a database schema, as given by \code{\link{normalise}},
\code{\link{synthesise}}, or \code{\link{autoref}}.}

\item{name}{a character scalar, giving the name of the schema, if any.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
A scalar character, containing text input for Graphviz.
}
\description{
Produces text input for Graphviz to make an HTML diagram of a given database
schema.
}
\details{
Each relation in the schema is presented as a set of rows, one for each
attribute in the relation. These rows do not include information about the
attribute classes.

Any foreign key references are represented by arrows
between the attribute pairs.
}
\seealso{
The generic \code{\link{gv}}.
}
