% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hdaftma.R
\name{hdaftma}
\alias{hdaftma}
\title{High dimensional multivariate accelerated failure time model with bayesian
       mediation analysis}
\usage{
hdaftma(m, n, survdur, event, ths, sig, b, d, data)
}
\arguments{
\item{m}{Starting column number from where high dimensional variates to be selected.}

\item{n}{Ending column number till where high dimensional variates to be selected.}

\item{survdur}{"Column/Variable name" consisting duration of survival.}

\item{event}{"Column/Variable name" consisting survival event.}

\item{ths}{A numeric between 0 to 100.}

\item{sig}{Level of significance.}

\item{b}{Number of MCMC iterations to burn.}

\item{d}{Number of draws for the iterations.}

\item{data}{High dimensional data containing survival observations and high dimensional covariates.}
}
\value{
Data frame containing the beta and alpha values of active variables among the significant variables.
}
\description{
Given the dimension of variables and survival information the function filters significant variables
by fitting AFT model. Further, it performs mediation analysis among the signifiant
variables and provides handful variables with their alpha.a values which are mediator model exposure coefficients
and beta.a coefficients.
}
\examples{
##
hdaftma(m=8,n=80,survdur="os",event="death",sig=0.05,ths=0.02,b=10,d=10,data=hnscc2)
##
}
