% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modelling.R
\name{plot_best_models}
\alias{plot_best_models}
\title{plot_best_models}
\usage{
plot_best_models(autofit, ncol = NULL, nrow = NULL)
}
\arguments{
\item{autofit}{Output of the autohrf function.}

\item{ncol}{Number of columns in the plot.}

\item{nrow}{Number of rows in the plot.}
}
\value{
Plots the grid containing a visualization of the best models for each
of the provided constraints.
}
\description{
Plots the best fitted model for each of the specs in autohrf.
}
\examples{
# prepare model specs
model3 <- data.frame(
  event        = c("encoding", "delay", "response"),
  start_time   = c(0,          2.65,     12.5),
  end_time     = c(3,          12.5,     16)
)

model4 <- data.frame(
  event        = c("fixation", "target", "delay", "response"),
  start_time   = c(0,          2.5,      2.65,    12.5),
  end_time     = c(2.5,        3,        12.5,    15.5)
)

model_constraints <- list(model3, model4)

# run autohrf
df <- swm
autofit <- autohrf(df, model_constraints, tr = 2.5,
                   population = 2, iter = 2, cores = 1)

# plot best models
plot_best_models(autofit)

}
