% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/document.R
\name{am_fork}
\alias{am_fork}
\title{Fork an Automerge document}
\usage{
am_fork(doc, heads = NULL)
}
\arguments{
\item{doc}{An Automerge document}

\item{heads}{Optional list of change hashes to fork at a specific point in
the document's history. If \code{NULL} (default) or an empty list, forks at
current heads. Each hash should be a raw vector (32 bytes).}
}
\value{
A new Automerge document (fork of the original)
}
\description{
Creates a fork of an Automerge document at the current heads or
at a specific point in history. The forked document shares history
with the original up to the fork point but can diverge afterwards.
}
\examples{
doc1 <- am_create()
doc2 <- am_fork(doc1)

# Now doc1 and doc2 can diverge independently
}
