% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AVNS_theo_covmat.R
\name{covmat_nswn}
\alias{covmat_nswn}
\title{Calculate Theoretical Covariance Matrix of Non-Stationary White Noise Process}
\usage{
covmat_nswn(sigma2, n_total)
}
\arguments{
\item{sigma2}{A \code{double} value for the variance parameter \eqn{\sigma ^2}{sigma^2}.}

\item{n_total}{An \code{integer} indicating the length of the whole non-stationary white noise
process.}
}
\value{
The theoretical covariance \code{matrix} of the non-stationary white noise process.
}
\description{
This function allows us to calculate the theoretical covariance matrix of a non-stationary
white noise process.
}
\note{
This function helps calculate the theoretical covariance matrix of a non-stationary
process, non-stationary white noise. It is helpful to calculate the theoretical allan variance of
non-stationary processes, which can be used to compare with the theoretical allan variance
of stationary processes as shown in "A Study of the Allan Variance for Constant-Mean Non-Stationary
Processes" by Xu et al., 2017, IEEE Signal Processing Letters, 24(8): 1257–1260.
}
\examples{
covmat1 = covmat_nswn(sigma2 = 1, n_total = 1000)
covmat2 = covmat_nswn(sigma2 = 2, n_total = 800)
}
\author{
Yuming Zhang
}
