% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.Date.aweek.R, R/conversions.R
\name{as.Date.aweek}
\alias{as.Date.aweek}
\alias{as.POSIXlt.aweek}
\alias{as.character.aweek}
\title{Convert aweek objects to characters or dates}
\usage{
\method{as.Date}{aweek}(x, floor_day = FALSE, ...)

\method{as.POSIXlt}{aweek}(x, tz = "", floor_day = FALSE, ...)

\method{as.character}{aweek}(x, ...)
}
\arguments{
\item{x}{an object of class \link[=print.aweek]{aweek}.}

\item{floor_day}{when \code{TRUE}, the days will be set to the start of the week.}

\item{...}{parameters passed to \code{as.POSIXlt()}.}

\item{tz}{passed on to \code{\link[=as.POSIXlt]{as.POSIXlt()}}}
}
\description{
Convert aweek objects to characters or dates
}
\examples{
w <- date2week(Sys.Date(), week_start = "Sunday")
w
# convert to POSIX
as.POSIXlt(w)
as.POSIXlt(w, floor_day = TRUE)
as.POSIXlt(w, floor_day = TRUE, tz = "KST")

# convert to date
as.Date(w)
as.Date(w, floor_day = TRUE)

# convert to character (strip attributes)
as.character(w)
}
\seealso{
\code{\link[=date2week]{date2week()}} \code{\link[=print.aweek]{print.aweek()}}
}
