% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_attach_network_interface}
\alias{ec2_attach_network_interface}
\title{Attach Network Interface}
\usage{
ec2_attach_network_interface(
  DeviceIndex,
  InstanceId,
  NetworkInterfaceId,
  DryRun = NULL,
  NetworkCardIndex = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{DeviceIndex}{Integer. The index of the device for the network interface attachment.}

\item{InstanceId}{String. The ID of the instance.}

\item{NetworkInterfaceId}{String. The ID of the network interface.}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{NetworkCardIndex}{Integer. The index of the network card.[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Attaches
a network interface to an instance.
}
\section{DeviceIndex}{

The index of the device for
the network interface attachment.
}

\section{InstanceId}{

The ID of the
instance.
}

\section{NetworkInterfaceId}{

The ID of the network
interface.
}

\section{DryRun}{

Checks whether you have the required
permissions for the action, without actually making the request, and
provides an error response. If you have the required permissions, the
error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

\section{NetworkCardIndex}{

The index of the network
card. Some instance types support multiple network cards. The primary
network interface must be assigned to network card index 0. The default
is network card index 0.
}

