% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_delete_dhcp_options}
\alias{ec2_delete_dhcp_options}
\title{Delete Dhcp Options}
\usage{
ec2_delete_dhcp_options(
  DhcpOptionsId,
  DryRun = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{DhcpOptionsId}{String. The ID of the DHCP options set.}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Deletes the specified set of DHCP
options. You must disassociate the set of DHCP options before you can
delete it. You can disassociate the set of DHCP options by associating
either a new set of options or the default set of options with the
VPC.
}
\section{DhcpOptionsId}{

The ID of the DHCP options
set.
}

\section{DryRun}{

Checks whether you have the required
permissions for the action, without actually making the request, and
provides an error response. If you have the required permissions, the
error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

