% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_delete_fleets}
\alias{ec2_delete_fleets}
\title{Delete Fleets}
\usage{
ec2_delete_fleets(
  FleetId,
  TerminateInstances,
  DryRun = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{FleetId}{List. The IDs of the EC2 Fleets.}

\item{TerminateInstances}{Logical.   Indicates whether to terminate the instances when the EC2 Fleet is deleted.}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Delete Fleets
}
\section{FleetId}{

The IDs of the EC2
Fleets.
}

\section{TerminateInstances}{


Indicates whether to terminate the instances when the EC2 Fleet is
deleted. The default is to terminate the instances.

To let the instances continue to run after the EC2 Fleet is deleted,
specify \code{NoTerminateInstances}. Supported only for fleets of type
\code{maintain} and \code{request}.

For \code{instant} fleets, you cannot specify \code{NoTerminateInstances}. A
deleted \code{instant} fleet with running instances is not supported.
}

\section{DryRun}{

Checks whether you have the required permissions
for the action, without actually making the request, and provides an
error response. If you have the required permissions, the error response
is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

