% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_delete_subnet}
\alias{ec2_delete_subnet}
\title{Delete Subnet}
\usage{
ec2_delete_subnet(SubnetId, DryRun = NULL, simplify = TRUE, others = list())
}
\arguments{
\item{SubnetId}{String. The ID of the subnet.}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Deletes the specified subnet. You must
terminate all running instances in the subnet before you can delete the
subnet.
}
\section{SubnetId}{

The ID of the
subnet.
}

\section{DryRun}{

Checks whether you have the required
permissions for the action, without actually making the request, and
provides an error response. If you have the required permissions, the
error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

