% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_delete_transit_gateway_route_table}
\alias{ec2_delete_transit_gateway_route_table}
\title{Delete Transit Gateway Route Table}
\usage{
ec2_delete_transit_gateway_route_table(
  TransitGatewayRouteTableId,
  DryRun = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{TransitGatewayRouteTableId}{String. The ID of the transit gateway route table.}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Deletes the
specified transit gateway route table. You must disassociate the route
table from any transit gateway route tables before you can delete
it.
}
\section{TransitGatewayRouteTableId}{

The ID of the transit
gateway route table.
}

\section{DryRun}{

Checks whether you have the
required permissions for the action, without actually making the
request, and provides an error response. If you have the required
permissions, the error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

