% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_get_managed_prefix_list_entries}
\alias{ec2_get_managed_prefix_list_entries}
\title{Get Managed Prefix List Entries}
\usage{
ec2_get_managed_prefix_list_entries(
  PrefixListId,
  DryRun = NULL,
  TargetVersion = NULL,
  MaxResults = NULL,
  NextToken = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{PrefixListId}{String. The ID of the prefix list.}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{TargetVersion}{Integer. The version of the prefix list for which to return the entries. The default is the current version.[optional]}

\item{MaxResults}{Integer. The maximum number of results to return with a single call.[optional]}

\item{NextToken}{Characters, The token for the next page of results[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Gets information about the entries for a
specified managed prefix list.
}
\section{PrefixListId}{

The ID of the prefix
list.
}

\section{DryRun}{

Checks whether you have the required
permissions for the action, without actually making the request, and
provides an error response. If you have the required permissions, the
error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

\section{TargetVersion}{

The version of the prefix
list for which to return the entries. The default is the current
version.
}

\section{MaxResults}{

The maximum number of results to return
with a single call. To retrieve the remaining results, make another call
with the returned \code{nextToken} value.
}

