% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_import_volume}
\alias{ec2_import_volume}
\title{Import Volume}
\usage{
ec2_import_volume(
  AvailabilityZone,
  Image,
  Volume,
  Description = NULL,
  DryRun = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{AvailabilityZone}{String. The Availability Zone for the resulting EBS volume.}

\item{Image}{Object. The disk image.}

\item{Volume}{Object. The volume size.}

\item{Description}{String. A description of the volume.[optional]}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Import Volume
}
\section{AvailabilityZone}{

The
Availability Zone for the resulting EBS volume.
}

\section{Image}{

The
disk image.
}

\section{Volume}{

The volume size.
}

\section{Description}{

A
description of the volume.
}

\section{DryRun}{

Checks whether you have
the required permissions for the action, without actually making the
request, and provides an error response. If you have the required
permissions, the error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

