% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_modify_instance_credit_specification}
\alias{ec2_modify_instance_credit_specification}
\title{Modify Instance Credit Specification}
\usage{
ec2_modify_instance_credit_specification(
  InstanceCreditSpecification,
  DryRun = NULL,
  ClientToken = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{InstanceCreditSpecification}{List. Information about the credit option for CPU usage.}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{ClientToken}{String. A unique, case-sensitive token that you provide to ensure idempotency of your modification request.[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Modify Instance Credit Specification
}
\section{InstanceCreditSpecification}{

Information about the
credit option for CPU usage.
}

\section{DryRun}{

Checks whether you have
the required permissions for the action, without actually making the
request, and provides an error response. If you have the required
permissions, the error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

\section{ClientToken}{

A unique, case-sensitive
token that you provide to ensure idempotency of your modification
request. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html}{Ensuring Idempotency}.
}

