% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_modify_reserved_instances}
\alias{ec2_modify_reserved_instances}
\title{Modify Reserved Instances}
\usage{
ec2_modify_reserved_instances(
  ReservedInstancesId,
  ReservedInstancesConfigurationSetItemType,
  ClientToken = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{ReservedInstancesId}{List. The IDs of the Reserved Instances to modify.}

\item{ReservedInstancesConfigurationSetItemType}{List. The configuration settings for the Reserved Instances to modify.}

\item{ClientToken}{String. A unique, case-sensitive token you provide to ensure idempotency of your modification request.[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Modify Reserved Instances
}
\section{ReservedInstancesId}{

The IDs of the Reserved Instances to
modify.
}

\section{ReservedInstancesConfigurationSetItemType}{

The configuration settings for the Reserved
Instances to modify.
}

\section{ClientToken}{

A unique, case-sensitive token
you provide to ensure idempotency of your modification request. For more
information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html}{Ensuring Idempotency}.
}

