% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_reset_address_attribute}
\alias{ec2_reset_address_attribute}
\title{Reset Address Attribute}
\usage{
ec2_reset_address_attribute(
  AllocationId,
  Attribute,
  DryRun = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{AllocationId}{String. [EC2-VPC] The allocation ID.}

\item{Attribute}{String. The attribute of the IP address.}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Resets the attribute of the specified IP address.
For requirements, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html#Using_Elastic_Addressing_Reverse_DNS}{Using reverse DNS for email applications}.
}
\section{AllocationId}{

[EC2-VPC] The
allocation ID.
}

\section{Attribute}{

The attribute of the IP
address.
}

\section{DryRun}{

Checks whether you have the required
permissions for the action, without actually making the request, and
provides an error response. If you have the required permissions, the
error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

