% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_restore_address_to_classic}
\alias{ec2_restore_address_to_classic}
\title{Restore Address To Classic}
\usage{
ec2_restore_address_to_classic(
  PublicIp,
  DryRun = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{PublicIp}{String. The Elastic IP address.}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Restores an Elastic IP address that was previously
moved to the EC2-VPC platform back to the EC2-Classic platform. You
cannot move an Elastic IP address that was originally allocated for use
in EC2-VPC. The Elastic IP address must not be associated with an
instance or network interface.
}
\section{PublicIp}{

The Elastic IP
address.
}

\section{DryRun}{

Checks whether you have the required
permissions for the action, without actually making the request, and
provides an error response. If you have the required permissions, the
error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

