% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_stop_instances}
\alias{ec2_stop_instances}
\title{Stop Instances}
\usage{
ec2_stop_instances(
  InstanceId,
  Hibernate = NULL,
  DryRun = NULL,
  Force = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{InstanceId}{List. The IDs of the instances.}

\item{Hibernate}{Logical.   Hibernates the instance if the instance was enabled for hibernation at launch.[optional]}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{Force}{Logical.   Forces the instances to stop.[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Stop Instances
}
\section{InstanceId}{

The IDs of the
instances.
}

\section{Hibernate}{


Hibernates the instance if the instance was enabled for hibernation at
launch. If the instance cannot hibernate successfully, a normal shutdown
occurs. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Hibernate.html}{Hibernate your instance}
in the \emph{Amazon EC2 User Guide}.

Default: \code{false}
}

\section{DryRun}{

Checks whether you have the required permissions
for the action, without actually making the request, and provides an
error response. If you have the required permissions, the error response
is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

\section{Force}{


Forces the instances to stop. The instances do not have an opportunity
to flush file system caches or file system metadata. If you use this
option, you must perform file system check and repair procedures. This
option is not recommended for Windows instances.

Default: \code{false}
}

