% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/publish.R
\name{publish}
\alias{publish}
\title{Publish to a topic or endpoint}
\usage{
publish(topic, endpoint, message, subject, ...)
}
\arguments{
\item{topic}{Optionally, a character string containing an SNS Topic Amazon Resource Name (ARN). Must specify \code{topic} or \code{endpoint}.}

\item{endpoint}{Optionally, a character string containing an SNS Application Endpoint ARN. Must specify \code{topic} or \code{endpoint}.}

\item{message}{Either a single character string containing a message to be sent to all endpoints, or a named list of messages to be sent to specific endpoints (where the names of each element correspond to endpoints).}

\item{subject}{Optionally, a character string containing a subject line (e.g., to be used for an email endpoint).}

\item{...}{Additional arguments passed to \code{\link{snsHTTP}}.}
}
\value{
If successful, a character string containing a message ID. Otherwise, a data structure of class \dQuote{aws_error} containing any error message(s) from AWS and information about the request attempt.
}
\description{
Publish a message to a specified topic or application endpoint.
}
\details{
Publishes a message to a topic or an application endpoint. Messages can be
the same for all endpoints or customized so that, for example, a short
140-character message is sent to SMS endpoints that are subscribed to a
topic while longer messages are sent to email endpoints, etc. The allowed
message types are: default, email, email-json, sqs, sms, http, https, and
application.
}
\examples{
\dontrun{
  top <- create_topic("new_topic")

  # simple notifications
  publish(top, message = "This is a notification message", subject = "Notification!")

  # endpoint-specific notification
  publish(top, message = list(sms = "This is an sms message", 
                              email = "This is an email"), 
          subject = "Notification!")

  delete_topic(top)
}

}
\author{
Thomas J. Leeper
}
\references{
\href{http://docs.aws.amazon.com/sns/latest/api/API_Publish.html}{Publish}
}

