% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datastore.R
\name{register_azure_sql_database_datastore}
\alias{register_azure_sql_database_datastore}
\title{Initialize a new Azure SQL database Datastore.}
\usage{
register_azure_sql_database_datastore(workspace, datastore_name,
  server_name, database_name, tenant_id, client_id, client_secret,
  resource_url = NULL, authority_url = NULL, endpoint = NULL,
  overwrite = FALSE, username = NULL, password = NULL)
}
\arguments{
\item{workspace}{The workspace this datastore belongs to.}

\item{datastore_name}{The datastore name.}

\item{server_name}{The SQL server name.}

\item{database_name}{The SQL database name.}

\item{tenant_id}{The Directory ID/Tenant ID of the service principal.}

\item{client_id}{The Client ID/Application ID of the service principal.}

\item{client_secret}{The secret of the service principal.}

\item{resource_url}{The resource URL, which determines what operations will
be performed on the SQL database store, if NULL, defaults to
https://database.windows.net/.}

\item{authority_url}{The authority URL used to authenticate the user, defaults
to https://login.microsoftonline.com.}

\item{endpoint}{The endpoint of the SQL server. If NULL, defaults to
database.windows.net.}

\item{overwrite}{Whether to overwrite an existing datastore. If the datastore does
not exist, it will create one. The default is FALSE.}

\item{username}{The username of the database user to access the database.}

\item{password}{The password of the database user to access the database.}
}
\value{
The \code{azureml.data.azure_sql_database_datastore.AzureSqlDatabaseDatastore}
object.
}
\description{
Initialize a new Azure SQL database Datastore.
}
