% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/config.R
\name{new_config}
\alias{new_config}
\title{Create a custom encoding engine}
\usage{
new_config(
  encode_padding = TRUE,
  decode_padding_trailing_bits = FALSE,
  decode_padding_mode = c("canonical", "indifferent", "none")
)
}
\arguments{
\item{encode_padding}{default \code{TRUE} add 1-2 trailing \code{=} to pad results}

\item{decode_padding_trailing_bits}{default \code{FALSE}. "If invalid trailing bits are present and this is true, those bits will be silently ignored." (See details for reference).}

\item{decode_padding_mode}{default \code{"canonical"}. Other values are \code{"indifferent"} and \code{"none"}. See details for more.}
}
\value{
an object of class \code{engine_config}
}
\description{
Create a custom encoding engine
}
\details{
See \href{https://docs.rs/base64/latest/base64/engine/general_purpose/struct.GeneralPurposeConfig.html#method.with_encode_padding}{base64 crate} for more details.
\subsection{Decode Padding Modes}{

There are three modes that can be used for \code{decode_padding_mode} argument.
\itemize{
\item \code{"canonical"}: padding must consist of 0, 1, or 2 \code{=} characters
\item \code{"none"}: there must be no padding characters present
\item \code{"indifferent"}: canonical padding is used, but omitted padding
characters are also permitted
}
}
}
\examples{
# create a new nonsensicle config
new_config(FALSE, TRUE, "none")
}
