% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/align_test_files.R
\name{align_test_files}
\alias{align_test_files}
\title{Align test sound files}
\usage{
align_test_files(
  X,
  Y,
  path = getOption("sound.files.path", "."),
  by.song = TRUE,
  marker = NULL,
  cores = getOption("mc.cores", 1),
  pb = getOption("pb", TRUE),
  ...
)
}
\arguments{
\item{X}{object of class 'data.frame', 'selection_table' or 'extended_selection_table' (the last 2 classes are created by the function \code{\link[warbleR]{selection_table}} from the warbleR package). This should be the same data than that was used for finding the position of markers in \code{\link{find_markers}}. It should also contain a 'sound.id' column that will be used to label re-recorded sounds according to their counterpart in the master sound file.}

\item{Y}{object of class 'data.frame' with the output of \code{\link{find_markers}}. This object contains the position of markers in the re-recorded sound files. If more than one marker is supplied for a sound file only the one with the highest correlation score ('scores' column in 'X') is used.}

\item{path}{Character string containing the directory path where test (re-recorded) sound files are found.}

\item{by.song}{Logical argument to indicate if the extended selection table should be created by song (see 'by.song' \code{\link[warbleR]{selection_table}} argument). Default is \code{TRUE}.}

\item{marker}{Character string to define whether a "start" or "end" marker would be used for aligning re-recorded sound files. Default is \code{NULL}. DEPRECATED.}

\item{cores}{Numeric vector of length 1. Controls whether parallel computing is applied by specifying the number of cores to be used. Default is 1 (i.e. no parallel computing). Can be set globally for the current R session via the "mc.cores" option (see \code{\link[base]{options}}).}

\item{pb}{Logical argument to control if progress bar is shown. Default is \code{TRUE}.  Can be set globally for the current R session via the "pb" option (see \code{\link[base]{options}}).}

\item{...}{Additional arguments to be passed to \code{\link[warbleR]{selection_table}} for customizing extended selection table.}
}
\value{
An object of the same class than 'X' with the aligned sounds from test (re-recorded) sound files.
}
\description{
\code{align_test_files} aligns test (re-recorded) sound files.
}
\details{
The function aligns sounds found in re-recorded sound files (referenced in 'Y') according to a master sound file (referenced in 'X'). If more than one marker is supplied for a sound file only the one with the highest correlation score ('scores' column in 'X') is used. The function outputs an 'extended selection table' by default.
}
\examples{
{
  # load example data
  data(list = c("master_est", "test_sounds_est"))

  # save example files in working director to recreate a case in which working
  # with sound files instead of extended selection tables.
  # This doesn't have to be done with your own data as you will
  # have them as sound files already.
  for (i in unique(test_sounds_est$sound.files)[1:2]) {
    writeWave(object = attr(test_sounds_est, "wave.objects")[[i]], 
              file.path(tempdir(), i))
  }

  # save master file
  writeWave(object = attr(master_est, "wave.objects")[[1]], 
        file.path(tempdir(), "master.wav"))

  # get marker position for the first test file
    markers <- find_markers(X = master_est,
    test.files = unique(test_sounds_est$sound.files)[1],
    path = tempdir())

  # align all test sounds
  alg.tests <- align_test_files(X = master_est, Y = markers, 
  path = tempdir())
}
}
\references{
{
Araya-Salas M., E. Grabarczyk, M. Quiroz-Oliva, A. Garcia-Rodriguez, A. Rico-Guevara. (2023), baRulho: an R package to quantify degradation in animal acoustic signals .bioRxiv 2023.11.22.568305.
}
}
\seealso{
\code{\link{manual_realign}}; \code{\link{find_markers}}; \code{\link{plot_aligned_sounds}}

Other test sound alignment: 
\code{\link{auto_realign}()},
\code{\link{find_markers}()},
\code{\link{manual_realign}()},
\code{\link{plot_aligned_sounds}()}
}
\author{
Marcelo Araya-Salas (\email{marcelo.araya@ucr.ac.cr})
}
\concept{test sound alignment}
