% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_aligned_sounds.R
\name{plot_aligned_sounds}
\alias{plot_aligned_sounds}
\title{Plot spectrograms to check test sound files alignment}
\usage{
plot_aligned_sounds(
  X,
  hop.size = getOption("hop.size", 11.6),
  wl = getOption("wl", NULL),
  ovlp = getOption("ovlp", 50),
  path = getOption("sound.files.path", "."),
  cores = getOption("mc.cores", 1),
  pb = getOption("pb", TRUE),
  collevels = seq(-120, 0, 5),
  palette = viridis::viridis,
  duration = 2,
  mar = 0.2,
  dest.path = getOption("dest.path", "."),
  flim = NULL,
  col = "white",
  width = 7,
  height = 4,
  res = 100,
  label = TRUE,
  fast.spec = FALSE,
  srt = 0,
  cex = 1,
  ...
)
}
\arguments{
\item{X}{Object of class 'data.frame', 'selection_table' or 'extended_selection_table' (the last 2 classes are created by the function \code{\link[warbleR]{selection_table}} from the warbleR package) with the reference to the test sounds . Must contain the following columns: 1) "sound.files": name of the .wav files, 2) "selec": unique selection identifier (within a sound file), 3) "start": start time and 4) "end": end time of selections, 5)  "bottom.freq": low frequency for bandpass, 6) "top.freq": high frequency for bandpass and 7) "sound.id": ID of sounds used to identify counterparts across distances. Each sound must have a unique ID within a distance.}

\item{hop.size}{A numeric vector of length 1 specifying the time window duration (in ms). Default is 11.6 ms, which is equivalent to 512 wl for a 44.1 kHz sampling rate. Ignored if 'wl' is supplied. Can be set globally for the current R session via the "hop.size" option (see \code{\link[base]{options}}).}

\item{wl}{A numeric vector of length 1 specifying the window length of the spectrogram, default
is NULL. Ignored if \code{bp = NULL}. If supplied, 'hop.size' is ignored.}

\item{ovlp}{Numeric vector of length 1 specifying the percentage of overlap between two
consecutive windows, as in \code{\link[seewave]{spectro}}. Default is 0. Can be set globally for the current R session via the "ovlp" option (see \code{\link[base]{options}}).}

\item{path}{Character string containing the directory path where the sound files are found. Only needed when 'X' is not an extended selection table. If not supplied the current working directory is used. Can be set globally for the current R session via the "sound.files.path" option (see \code{\link[base]{options}}).}

\item{cores}{Numeric vector of length 1. Controls whether parallel computing is applied by specifying the number of cores to be used. Default is 1 (i.e. no parallel computing). Can be set globally for the current R session via the "mc.cores" option (see \code{\link[base]{options}}).}

\item{pb}{Logical argument to control if progress bar is shown. Default is \code{TRUE}.  Can be set globally for the current R session via the "pb" option (see \code{\link[base]{options}}).}

\item{collevels}{A numeric vector of length 3. Specifies levels to partition the
amplitude range of the spectrogram (in dB). The more levels the higher the
resolution of the spectrogram. Default is seq(-40, 0, 1). seq(-115, 0, 1) will produces spectrograms
similar to other acoustic analysis software packages.}

\item{palette}{Color palette function for spectrogram. Default is  \code{\link[viridis]{viridis}}. See
\code{\link[seewave]{spectro}} for more palettes. Palettes as \code{\link[monitoR:specCols]{gray.2}} may work better when \code{fast.spec = TRUE}.}

\item{duration}{A numeric vector of length 1. Specifies the overall duration of the clip that will be plotted. Notice that only the initial part of the test files are plotted as this is enough to tell the precision of the alignment.}

\item{mar}{numeric vector of length 1. Specifies the margins adjacent to the start of the first annotation to be included in the plot.}

\item{dest.path}{Character string containing the directory path where the image files will be saved. If not supplied the current working directory will be used instead. Can be set globally for the current R session via the "dest.path" option (see \code{\link[base]{options}}).}

\item{flim}{A numeric vector of length 2 indicating the highest and lowest frequency limits (kHz) of the spectrogram, as in \code{\link[seewave]{spectro}}. Default is \code{NULL} which will plot spectrograms in the full frequency range (0 - nyquist frequency).}

\item{col}{Character string controlling the color of lines and sound ID labels.}

\item{width}{Numeric vector of length 1. Single value (in inches) indicating the width of the output image files. Default is 7.}

\item{height}{Numeric vector of length 1. Single value (in inches) indicating the height of the output image files. Default is 4.}

\item{res}{Numeric argument of length 1. Controls image resolution. Default is 100 (faster) although 300 - 400 is recommended for publication/presentation quality.}

\item{label}{Logical to control if labels (from 'sound.id' column in 'X') are plotted. Default is  \code{TRUE}.}

\item{fast.spec}{Logical. If \code{TRUE} then image function is used internally to create spectrograms, which substantially
increases performance (much faster), although some options become unavailable, as collevels (amplitude scale). Default is \code{FALSE}.}

\item{srt}{Numeric argument of length 1. The rotation (in degrees) of the sound id labels. Default is 0.}

\item{cex}{Numeric argument of length 1controlling the size of sound id text labels. Default is 1.}

\item{...}{Additional arguments to be passed to the internal spectrogram
creating function for customizing graphical output. The function is a modified
version of \code{\link[seewave]{spectro}}, so it takes the same arguments.}
}
\value{
Image files in jpeg format with spectrograms in the working directory, one for each sound file in 'X'. It also returns the file path of the images invisibly.
}
\description{
\code{plot_aligned_sounds} plots spectrograms to visually inspect alignment precision on test sound files.
}
\details{
This functions aims to simplify the evaluation of the alignment of test sound files from  \code{\link{align_test_files}}. The function creates a single spectrogram for each sound file (saved at 'dest.path'). Spectrograms include the first few seconds of the sound files (controlled by 'duration') which is usually enough to tell the precision of the alignment. The plots include vertical lines denoting the start and end of each sound as well as the sound ID ('sound.id' column in 'X'). Note that no plot is created in the R graphic device.
}
\examples{
{
  # load example data
  data("test_sounds_est")

  # plot (look into temporary working directory `tempdir()`)
  plot_aligned_sounds(X = test_sounds_est, dest.path = tempdir(), duration = 3, ovlp = 0)
}

}
\references{
{
Araya-Salas M., E. Grabarczyk, M. Quiroz-Oliva, A. Garcia-Rodriguez, A. Rico-Guevara. (2023), baRulho: an R package to quantify degradation in animal acoustic signals .bioRxiv 2023.11.22.568305.
}
}
\seealso{
\code{\link{manual_realign}};  \code{\link{auto_realign}}; \code{\link{find_markers}}; \code{\link{align_test_files}}

Other test sound alignment: 
\code{\link{align_test_files}()},
\code{\link{auto_realign}()},
\code{\link{find_markers}()},
\code{\link{manual_realign}()}
}
\author{
Marcelo Araya-Salas (\email{marcelo.araya@ucr.ac.cr})
}
\concept{test sound alignment}
