% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{popedMultipleEndpointParam}
\alias{popedMultipleEndpointParam}
\title{Populates Multiple Endpoint Parameters for internal solving}
\usage{
popedMultipleEndpointParam(p, times, modelSwitch, maxMT, optTime = TRUE)
}
\arguments{
\item{p}{A numeric vector of parameters}

\item{times}{A numeric vector of times}

\item{modelSwitch}{An integer vector indicating model switches from PopED}

\item{maxMT}{An integer specifying the maximum number of time
points in the mtimes model}
}
\value{
A numeric vector containing the parameters followed by
unique times, if the maximum number of times is greater than the
input this will append the maximum observed times in the
input. This assumes the first parameter is the id and is dropped
fro the output.
}
\description{
This function populates a numeric vector with parameters and
unique times and also populates the internal C++ global index
}
\details{
\itemize{
\item This function first uses the input times and model switches to
a global time indexer.
\item It then creates a new numeric vector
that combines the input parameters and unique times.  If the
number of times is less than \code{maxMT}, the remaining elements are
filled with the maximum time.
}
}
\examples{

\donttest{

p <- c(1.0, 2.0, 3.0)
times <- c(0.5, 1.5, 2.5)
modelSwitch <- c(1, 2, 3)
maxMT <- 5
popedMultipleEndpointParam(p, times, modelSwitch, maxMT)

}
}
\author{
Matthew L. Fidler
}
\keyword{internal}
