% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fixedfill.R
\name{fixedfill}
\alias{fixedfill}
\title{Compute fixed fill backbone probabilities}
\usage{
fixedfill(B)
}
\arguments{
\item{B}{graph: An unweighted bipartite graph object of class matrix, sparse matrix, igraph, edgelist, or network object.
Any rows and columns of the associated bipartite matrix that contain only zeros are automatically removed before computations.}
}
\value{
backbone, a list(positive, negative, summary). Here
    `positive` is a matrix of probabilities of edge weights being equal to or above the observed value in the projection,
    `negative` is a matrix of probabilities of edge weights being equal to or below the observed value in the projection, and
    `summary` is a data frame summary of the inputted matrix and the model used including: model name, number of rows, skew of row sums, number of columns, skew of column sums, and running time.
}
\description{
`fixedfill` computes the probability of observing
    a higher or lower edge weight.
    Once computed, use \code{\link{backbone.extract}} to return
    the backbone matrix for a given alpha value.
}
\details{
Specifically, this function compares an edge's observed weight in the projection \eqn{B*t(B)} to the
    distribution of weights expected in a projection obtained from a random bipartite graph where
    the number of edges present is equal to the number of edges in B.
}
\examples{
fixed_probs <- fixedfill(davis)
}
