% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bipartite.from.distribution.R
\name{bipartite.from.distribution}
\alias{bipartite.from.distribution}
\title{Generates a bipartite network with given row and column degree distributions}
\usage{
bipartite.from.distribution(
  R,
  C,
  P,
  rowdist = c(1, 1),
  coldist = c(1, 1),
  class = "matrix"
)
}
\arguments{
\item{R}{integer: number of rows}

\item{C}{integer: number of columns}

\item{P}{numeric: probability of an edge}

\item{rowdist}{vector length 2: Row degrees will approximately follow a Beta(a,b) distribution}

\item{coldist}{vector length 2: Column degrees will approximately follow a Beta(a,b) distribution}

\item{class}{string: the class of the returned backbone graph, one of c("matrix", "Matrix", "sparseMatrix", "igraph", "network")}
}
\description{
`bipartite.from.distribution` returns a bipartite graph, as an object of the requested class,
with row and column degree distributions that approximately follow beta distributions with given parameters.
}
\examples{
B <- bipartite.from.distribution(R = 100, C = 100, P = 0.1,
rowdist = c(1,1), coldist = c(1,1))  #Uniform
B <- bipartite.from.distribution(R = 100, C = 100, P = 0.1,
rowdist = c(1,10), coldist = c(1,10))  #Right-tailed
B <- bipartite.from.distribution(R = 100, C = 100, P = 0.1,
rowdist = c(10,1), coldist = c(10,1))  #Left-tailed
B <- bipartite.from.distribution(R = 100, C = 100, P = 0.1,
rowdist = c(10,10), coldist = c(10,10))  #Normal
B <- bipartite.from.distribution(R = 100, C = 100, P = 0.1,
rowdist = c(10000,10000), coldist = c(10000,10000))  #Constant
}
