% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write.narrative.R
\name{write.narrative}
\alias{write.narrative}
\title{Generates suggested manuscript text}
\usage{
write.narrative(
  agents = 0,
  artifacts = 0,
  weighted = FALSE,
  bipartite = FALSE,
  symmetric = FALSE,
  signed = FALSE,
  mtc = "none",
  alpha = NULL,
  s = NULL,
  ut = NULL,
  lt = NULL,
  trials = 0,
  escore = NULL,
  normalize = NULL,
  filter = NULL,
  umst = NULL,
  model = "",
  reduced_edges = NULL,
  reduced_nodes = NULL
)
}
\arguments{
\item{agents}{integer: number of agents in a bipartite graph, or nodes in a unipartite graph}

\item{artifacts}{integer: number of artifacts in a bipartite graph}

\item{weighted}{boolean: TRUE if input graph was weighted}

\item{bipartite}{boolean: TRUE if input graph was bipartite}

\item{symmetric}{boolean: TRUE if input graph was symmetric}

\item{signed}{boolean: TRUE if a signed backbone was requested}

\item{mtc}{string: type of multiple test correction}

\item{alpha}{numeric: alpha significance threshold (used in statistical models)}

\item{s}{numeric: sparsification parameter (used in sparsification models)}

\item{ut}{numeric: upper threshold (used in global threshold)}

\item{lt}{numeric: lower threshold (used in global threshold)}

\item{trials}{integer: number of trials used to estimate FDSM or oSDSM p-values}

\item{escore}{string: Method for scoring edges' importance}

\item{normalize}{string: Method for normalizing edge scores}

\item{filter}{string: Type of filter to apply}

\item{umst}{boolean: TRUE if the backbone should include the union of minimum spanning trees, to ensure connectivity}

\item{model}{string: name of backbone model}

\item{reduced_edges}{numeric: percent reduction in number of edges}

\item{reduced_nodes}{numeric: percent reduction in number of connected nodes}
}
\value{
NULL; only displays text in the console
}
\description{
\code{write.narrative} displays suggested text and references that can be used in a manuscript to describe the extracted backbone
}
\keyword{internal}
