% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bage_mod-methods.R
\name{replicate_data}
\alias{replicate_data}
\title{Create Replicate Data}
\usage{
replicate_data(x, condition_on = NULL, n = 19)
}
\arguments{
\item{x}{A fitted model, typically created by
calling \code{\link[=mod_pois]{mod_pois()}}, \code{\link[=mod_binom]{mod_binom()}}, or \code{\link[=mod_norm]{mod_norm()}},
and then \code{\link[=fit]{fit()}}.}

\item{condition_on}{Parameters to condition
on. Either \code{"expected"} or \code{"fitted"}. See
details.}

\item{n}{Number of replicate datasets to create.
Default is 19.}
}
\value{
A \link[tibble:tibble-package]{tibble}
with the following structure:\tabular{ll}{
   \code{.replicate} \tab data \cr
   \code{"Original"} \tab Original data supplied to \code{\link[=mod_pois]{mod_pois()}}, \code{\link[=mod_binom]{mod_binom()}}, \code{\link[=mod_norm]{mod_norm()}} \cr
   \code{"Replicate 1"} \tab Simulated data. \cr
   \code{"Replicate 2"} \tab Simulated data. \cr
   \dots \tab \dots \cr
   \code{"Replicate <n>"} \tab Simulated data. \cr
}
}
\description{
Use a fitted model to create replicate datasets,
typically as a way of checking a model.
}
\details{
Use \code{n} draws from the posterior distribution
for model parameters to generate \code{n} simulated datasets.
If the model is working well, these simulated
datasets should look similar to the actual dataset.
}
\section{The \code{condition_on} argument}{


With Poisson and binomial models that include
dispersion terms (which is the default), there are
two options for constructing replicate data.
\itemize{
\item When \code{condition_on} is \code{"fitted"},
the replicate data is created by (i) drawing values
from the posterior distribution for rates or probabilities
(the \eqn{\gamma_i} defined in \code{\link[=mod_pois]{mod_pois()}}
and \code{\link[=mod_binom]{mod_binom()}}), and (ii)  conditional on these
rates or probabilities, drawing values for the
outcome variable.
\item When \code{condition_on} is \code{"expected"},
the replicate data is created by (i) drawing
values from hyper-parameters governing
the rates or probabilities
(the \eqn{\mu_i} and \eqn{\xi} defined
in \code{\link[=mod_pois]{mod_pois()}} and \code{\link[=mod_binom]{mod_binom()}}),
then (ii) conditional on these hyper-parameters,
drawing values for the rates or probabilities,
and finally (iii) conditional on these
rates or probabilities, drawing values for the
outcome variable.
}

The default for \code{condition_on} is \code{"expected"}.
The \code{"expected"} option
provides a more severe test for
a model than the \code{"fitted"} option,
since "fitted" values are weighted averages
of the "expected" values and the original
data.

As described in \code{\link[=mod_norm]{mod_norm()}}, normal models
have a different structure from Poisson
and binomial models, and the distinction between
\code{"fitted"} and \code{"expected"} does not apply.
}

\section{Data models for outcomes}{


If a \link[=datamods]{data model} has been provided for
the outcome variable, then creation of replicate
data will include a step where errors are added
to outcomes. For instance, the a \link[=set_datamod_outcome_rr3]{rr3}
data model is used, then \code{replicate_data()} rounds
the outcomes to base 3.
}

\examples{
mod <- mod_pois(injuries ~ age:sex + ethnicity + year,
                data = nzl_injuries,
                exposure = 1) |>
  fit()

rep_data <- mod |>
  replicate_data()

library(dplyr)
rep_data |>
  group_by(.replicate) |>
  count(wt = injuries)

## when the overall model includes an rr3 data model,
## replicate data are rounded to base 3
mod_pois(injuries ~ age:sex + ethnicity + year,
         data = nzl_injuries,
         exposure = popn) |>
  set_datamod_outcome_rr3() |>
  fit() |>
  replicate_data()
}
\seealso{
\itemize{
\item \code{\link[=mod_pois]{mod_pois()}} Specify a Poisson model
\item \code{\link[=mod_binom]{mod_binom()}} Specify a binomial model
\item \code{\link[=mod_norm]{mod_norm()}} Specify a normal model
\item \code{\link[=fit]{fit()}} Fit model.
\item \code{\link[=augment]{augment()}} Extract values for rates,
probabilities, or means, together
with original data
\item \code{\link[=components]{components()}} Extract values for hyper-parameters
\item \code{\link[=forecast]{forecast()}} Forecast, based on a model
\item \code{\link[=report_sim]{report_sim()}} Simulation study of model.
\item \href{https://bayesiandemography.github.io/bage/articles/vig2_math.html}{Mathematical Details}
vignette
}
}
