// Generated by rstantools.  Do not edit by hand.

/*
    baggr is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    baggr is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with baggr.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#ifndef USE_STANC3
#define USE_STANC3
#endif
#include <rstan/rstaninc.hpp>
// Code generated by stanc v2.26.1-1-g67504470
#include <stan/model/model_header.hpp>
namespace model_rubin_namespace {
inline void validate_positive_index(const char* var_name, const char* expr,
                                    int val) {
  if (val < 1) {
    std::stringstream msg;
    msg << "Found dimension size less than one in simplex declaration"
        << "; variable=" << var_name << "; dimension size expression=" << expr
        << "; expression value=" << val;
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
inline void validate_unit_vector_index(const char* var_name, const char* expr,
                                       int val) {
  if (val <= 1) {
    std::stringstream msg;
    if (val == 1) {
      msg << "Found dimension size one in unit vector declaration."
          << " One-dimensional unit vector is discrete"
          << " but the target distribution must be continuous."
          << " variable=" << var_name << "; dimension size expression=" << expr;
    } else {
      msg << "Found dimension size less than one in unit vector declaration"
          << "; variable=" << var_name << "; dimension size expression=" << expr
          << "; expression value=" << val;
    }
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using std::pow;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::model_base_crtp;
using stan::model::rvalue;
using stan::model::cons_list;
using stan::model::index_uni;
using stan::model::index_max;
using stan::model::index_min;
using stan::model::index_min_max;
using stan::model::index_multi;
using stan::model::index_omni;
using stan::model::nil_index_list;
using namespace stan::math;
using stan::math::pow; 
stan::math::profile_map profiles__;
static int current_statement__= 0;
static const std::vector<string> locations_array__ = {" (found before start of program)",
                                                      " (in 'string', line 50, column 2 to column 29)",
                                                      " (in 'string', line 51, column 2 to column 39)",
                                                      " (in 'string', line 52, column 2 to column 23)",
                                                      " (in 'string', line 53, column 2 to column 18)",
                                                      " (in 'string', line 59, column 2 to column 27)",
                                                      " (in 'string', line 63, column 4 to column 33)",
                                                      " (in 'string', line 62, column 7 to line 63, column 33)",
                                                      " (in 'string', line 61, column 4 to column 18)",
                                                      " (in 'string', line 60, column 2 to line 63, column 33)",
                                                      " (in 'string', line 89, column 2 to column 25)",
                                                      " (in 'string', line 90, column 2 to column 27)",
                                                      " (in 'string', line 95, column 6 to column 30)",
                                                      " (in 'string', line 93, column 6 to column 42)",
                                                      " (in 'string', line 92, column 4 to line 95, column 30)",
                                                      " (in 'string', line 96, column 4 to column 17)",
                                                      " (in 'string', line 99, column 8 to column 108)",
                                                      " (in 'string', line 98, column 6 to line 99, column 108)",
                                                      " (in 'string', line 101, column 8 to column 90)",
                                                      " (in 'string', line 100, column 6 to line 101, column 90)",
                                                      " (in 'string', line 97, column 22 to line 102, column 5)",
                                                      " (in 'string', line 97, column 4 to line 102, column 5)",
                                                      " (in 'string', line 91, column 16 to line 103, column 3)",
                                                      " (in 'string', line 91, column 2 to line 103, column 3)",
                                                      " (in 'string', line 66, column 9 to column 10)",
                                                      " (in 'string', line 66, column 2 to column 17)",
                                                      " (in 'string', line 71, column 6 to column 20)",
                                                      " (in 'string', line 72, column 6 to column 54)",
                                                      " (in 'string', line 70, column 9 to line 73, column 5)",
                                                      " (in 'string', line 69, column 6 to column 32)",
                                                      " (in 'string', line 68, column 15 to line 70, column 5)",
                                                      " (in 'string', line 68, column 4 to line 73, column 5)",
                                                      " (in 'string', line 67, column 11 to line 74, column 3)",
                                                      " (in 'string', line 67, column 2 to line 74, column 3)",
                                                      " (in 'string', line 84, column 4 to column 64)",
                                                      " (in 'string', line 85, column 4 to column 51)",
                                                      " (in 'string', line 83, column 7 to line 86, column 3)",
                                                      " (in 'string', line 79, column 4 to column 64)",
                                                      " (in 'string', line 80, column 4 to column 61)",
                                                      " (in 'string', line 81, column 4 to column 22)",
                                                      " (in 'string', line 82, column 4 to column 53)",
                                                      " (in 'string', line 78, column 29 to line 83, column 3)",
                                                      " (in 'string', line 78, column 8 to line 86, column 3)",
                                                      " (in 'string', line 76, column 4 to column 61)",
                                                      " (in 'string', line 77, column 4 to column 53)",
                                                      " (in 'string', line 75, column 23 to line 78, column 3)",
                                                      " (in 'string', line 75, column 2 to line 86, column 3)",
                                                      " (in 'string', line 25, column 2 to column 19)",
                                                      " (in 'string', line 27, column 2 to column 17)",
                                                      " (in 'string', line 28, column 9 to column 10)",
                                                      " (in 'string', line 28, column 2 to column 24)",
                                                      " (in 'string', line 29, column 18 to column 19)",
                                                      " (in 'string', line 29, column 2 to column 32)",
                                                      " (in 'string', line 30, column 2 to column 18)",
                                                      " (in 'string', line 31, column 9 to column 10)",
                                                      " (in 'string', line 31, column 11 to column 13)",
                                                      " (in 'string', line 31, column 2 to column 17)",
                                                      " (in 'string', line 33, column 2 to column 26)",
                                                      " (in 'string', line 34, column 2 to column 24)",
                                                      " (in 'string', line 35, column 2 to column 21)",
                                                      " (in 'string', line 36, column 2 to column 32)",
                                                      " (in 'string', line 37, column 2 to column 30)",
                                                      " (in 'string', line 38, column 2 to column 27)",
                                                      " (in 'string', line 40, column 2 to column 22)",
                                                      " (in 'string', line 41, column 9 to column 15)",
                                                      " (in 'string', line 41, column 2 to column 34)",
                                                      " (in 'string', line 42, column 18 to column 24)",
                                                      " (in 'string', line 42, column 2 to column 42)",
                                                      " (in 'string', line 43, column 9 to column 15)",
                                                      " (in 'string', line 43, column 16 to column 18)",
                                                      " (in 'string', line 43, column 2 to column 27)",
                                                      " (in 'string', line 46, column 2 to column 43)",
                                                      " (in 'string', line 47, column 9 to column 15)",
                                                      " (in 'string', line 47, column 2 to column 71)",
                                                      " (in 'string', line 50, column 10 to column 27)",
                                                      " (in 'string', line 51, column 20 to column 37)",
                                                      " (in 'string', line 52, column 9 to column 17)",
                                                      " (in 'string', line 53, column 9 to column 11)",
                                                      " (in 'string', line 59, column 9 to column 17)",
                                                      " (in 'string', line 89, column 13 to column 23)",
                                                      " (in 'string', line 90, column 9 to column 15)",
                                                      " (in 'string', line 11, column 9 to column 66)",
                                                      " (in 'string', line 9, column 25 to column 73)",
                                                      " (in 'string', line 9, column 9 to line 11, column 66)",
                                                      " (in 'string', line 6, column 25 to column 70)",
                                                      " (in 'string', line 6, column 9 to line 11, column 66)",
                                                      " (in 'string', line 5, column 25 to column 70)",
                                                      " (in 'string', line 5, column 9 to line 11, column 66)",
                                                      " (in 'string', line 4, column 20 to column 66)",
                                                      " (in 'string', line 4, column 4 to line 11, column 66)",
                                                      " (in 'string', line 3, column 60 to line 12, column 3)",
                                                      " (in 'string', line 20, column 9 to column 66)",
                                                      " (in 'string', line 18, column 25 to column 73)",
                                                      " (in 'string', line 18, column 9 to line 20, column 66)",
                                                      " (in 'string', line 17, column 25 to column 70)",
                                                      " (in 'string', line 17, column 9 to line 20, column 66)",
                                                      " (in 'string', line 16, column 25 to column 70)",
                                                      " (in 'string', line 16, column 9 to line 20, column 66)",
                                                      " (in 'string', line 15, column 20 to column 66)",
                                                      " (in 'string', line 15, column 4 to line 20, column 66)",
                                                      " (in 'string', line 14, column 61 to line 21, column 3)"};
template <bool propto__, typename T0__, typename T2__>
stan::promote_args_t<T0__,
stan::value_type_t<T2__>>
realprior_lpdf(const T0__& theta, const int& family, const T2__& pars_arg__,
               std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<T0__,
          stan::value_type_t<T2__>>;
  const auto& pars = to_ref(pars_arg__);
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    current_statement__ = 89;
    if (logical_eq(family, 0)) {
      current_statement__ = 88;
      return uniform_lpdf<false>(theta, pars[(1 - 1)], pars[(2 - 1)]);
    } else {
      current_statement__ = 87;
      if (logical_eq(family, 1)) {
        current_statement__ = 86;
        return normal_lpdf<false>(theta, pars[(1 - 1)], pars[(2 - 1)]);
      } else {
        current_statement__ = 85;
        if (logical_eq(family, 2)) {
          current_statement__ = 84;
          return cauchy_lpdf<false>(theta, pars[(1 - 1)], pars[(2 - 1)]);
        } else {
          current_statement__ = 83;
          if (logical_eq(family, 5)) {
            current_statement__ = 82;
            return lognormal_lpdf<false>(theta, pars[(1 - 1)], pars[(2 - 1)]);
          } else {
            current_statement__ = 81;
            return student_t_lpdf<false>(theta, pars[(1 - 1)], pars[(2 - 1)],
                     pars[(3 - 1)]);
          }
        }
      }
    }
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct realprior_lpdf_functor__ {
template <bool propto__, typename T0__, typename T2__>
stan::promote_args_t<T0__,
stan::value_type_t<T2__>>
operator()(const T0__& theta, const int& family, const T2__& pars,
           std::ostream* pstream__)  const 
{
return realprior_lpdf<propto__>(theta, family, pars, pstream__);
}
};
template <bool propto__, typename T0__, typename T2__>
stan::promote_args_t<stan::value_type_t<T0__>,
stan::value_type_t<T2__>>
vecprior_lpdf(const T0__& theta_arg__, const int& family,
              const T2__& pars_arg__, std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<stan::value_type_t<T0__>,
          stan::value_type_t<T2__>>;
  const auto& theta = to_ref(theta_arg__);
  const auto& pars = to_ref(pars_arg__);
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    current_statement__ = 99;
    if (logical_eq(family, 0)) {
      current_statement__ = 98;
      return uniform_lpdf<false>(theta, pars[(1 - 1)], pars[(2 - 1)]);
    } else {
      current_statement__ = 97;
      if (logical_eq(family, 1)) {
        current_statement__ = 96;
        return normal_lpdf<false>(theta, pars[(1 - 1)], pars[(2 - 1)]);
      } else {
        current_statement__ = 95;
        if (logical_eq(family, 2)) {
          current_statement__ = 94;
          return cauchy_lpdf<false>(theta, pars[(1 - 1)], pars[(2 - 1)]);
        } else {
          current_statement__ = 93;
          if (logical_eq(family, 5)) {
            current_statement__ = 92;
            return lognormal_lpdf<false>(theta, pars[(1 - 1)], pars[(2 - 1)]);
          } else {
            current_statement__ = 91;
            return student_t_lpdf<false>(theta, pars[(1 - 1)], pars[(2 - 1)],
                     pars[(3 - 1)]);
          }
        }
      }
    }
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct vecprior_lpdf_functor__ {
template <bool propto__, typename T0__, typename T2__>
stan::promote_args_t<stan::value_type_t<T0__>,
stan::value_type_t<T2__>>
operator()(const T0__& theta, const int& family, const T2__& pars,
           std::ostream* pstream__)  const 
{
return vecprior_lpdf<propto__>(theta, family, pars, pstream__);
}
};
#include <stan_meta_header.hpp>
class model_rubin final : public model_base_crtp<model_rubin> {
private:
  int pooling_type;
  int K;
  Eigen::Matrix<double, -1, 1> theta_hat_k;
  Eigen::Matrix<double, -1, 1> se_theta_k;
  int Nc;
  Eigen::Matrix<double, -1, -1> X;
  int prior_hypermean_fam;
  int prior_hypersd_fam;
  int prior_beta_fam;
  Eigen::Matrix<double, -1, 1> prior_hypermean_val;
  Eigen::Matrix<double, -1, 1> prior_hypersd_val;
  Eigen::Matrix<double, -1, 1> prior_beta_val;
  int K_test;
  Eigen::Matrix<double, -1, 1> test_theta_hat_k;
  Eigen::Matrix<double, -1, 1> test_se_theta_k;
  Eigen::Matrix<double, -1, -1> X_test;
  int K_pooled;
  Eigen::Matrix<double, -1, 1> test_var_theta_k;
  int mu_1dim__;
  int tau_1dim__;
  int logpd_1dim__;
 
public:
  ~model_rubin() { }
  
  inline std::string model_name() const final { return "model_rubin"; }
  inline std::vector<std::string> model_compile_info() const noexcept {
    return std::vector<std::string>{"stanc_version = stanc3 v2.26.1-1-g67504470", "stancflags = "};
  }
  
  
  model_rubin(stan::io::var_context& context__,
              unsigned int random_seed__ = 0,
              std::ostream* pstream__ = nullptr) : model_base_crtp(0) {
    using local_scalar_t__ = double ;
    boost::ecuyer1988 base_rng__ = 
        stan::services::util::create_rng(random_seed__, 0);
    (void) base_rng__;  // suppress unused var warning
    static const char* function__ = "model_rubin_namespace::model_rubin";
    (void) function__;  // suppress unused var warning
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      current_statement__ = 47;
      context__.validate_dims("data initialization","pooling_type","int",
          context__.to_vec());
      pooling_type = std::numeric_limits<int>::min();
      
      current_statement__ = 47;
      pooling_type = context__.vals_i("pooling_type")[(1 - 1)];
      current_statement__ = 48;
      context__.validate_dims("data initialization","K","int",
          context__.to_vec());
      K = std::numeric_limits<int>::min();
      
      current_statement__ = 48;
      K = context__.vals_i("K")[(1 - 1)];
      current_statement__ = 48;
      current_statement__ = 48;
      check_greater_or_equal(function__, "K", K, 0);
      current_statement__ = 49;
      validate_non_negative_index("theta_hat_k", "K", K);
      current_statement__ = 50;
      context__.validate_dims("data initialization","theta_hat_k","double",
          context__.to_vec(K));
      theta_hat_k = Eigen::Matrix<double, -1, 1>(K);
      stan::math::fill(theta_hat_k, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> theta_hat_k_flat__;
        current_statement__ = 50;
        assign(theta_hat_k_flat__, nil_index_list(),
          context__.vals_r("theta_hat_k"),
          "assigning variable theta_hat_k_flat__");
        current_statement__ = 50;
        pos__ = 1;
        current_statement__ = 50;
        for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
          current_statement__ = 50;
          assign(theta_hat_k, cons_list(index_uni(sym1__), nil_index_list()),
            theta_hat_k_flat__[(pos__ - 1)], "assigning variable theta_hat_k");
          current_statement__ = 50;
          pos__ = (pos__ + 1);}
      }
      current_statement__ = 51;
      validate_non_negative_index("se_theta_k", "K", K);
      current_statement__ = 52;
      context__.validate_dims("data initialization","se_theta_k","double",
          context__.to_vec(K));
      se_theta_k = Eigen::Matrix<double, -1, 1>(K);
      stan::math::fill(se_theta_k, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> se_theta_k_flat__;
        current_statement__ = 52;
        assign(se_theta_k_flat__, nil_index_list(),
          context__.vals_r("se_theta_k"),
          "assigning variable se_theta_k_flat__");
        current_statement__ = 52;
        pos__ = 1;
        current_statement__ = 52;
        for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
          current_statement__ = 52;
          assign(se_theta_k, cons_list(index_uni(sym1__), nil_index_list()),
            se_theta_k_flat__[(pos__ - 1)], "assigning variable se_theta_k");
          current_statement__ = 52;
          pos__ = (pos__ + 1);}
      }
      current_statement__ = 52;
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        current_statement__ = 52;
        current_statement__ = 52;
        check_greater_or_equal(function__, "se_theta_k[sym1__]",
                               se_theta_k[(sym1__ - 1)], 0);}
      current_statement__ = 53;
      context__.validate_dims("data initialization","Nc","int",
          context__.to_vec());
      Nc = std::numeric_limits<int>::min();
      
      current_statement__ = 53;
      Nc = context__.vals_i("Nc")[(1 - 1)];
      current_statement__ = 53;
      current_statement__ = 53;
      check_greater_or_equal(function__, "Nc", Nc, 0);
      current_statement__ = 54;
      validate_non_negative_index("X", "K", K);
      current_statement__ = 55;
      validate_non_negative_index("X", "Nc", Nc);
      current_statement__ = 56;
      context__.validate_dims("data initialization","X","double",
          context__.to_vec(K, Nc));
      X = Eigen::Matrix<double, -1, -1>(K, Nc);
      stan::math::fill(X, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> X_flat__;
        current_statement__ = 56;
        assign(X_flat__, nil_index_list(), context__.vals_r("X"),
          "assigning variable X_flat__");
        current_statement__ = 56;
        pos__ = 1;
        current_statement__ = 56;
        for (int sym1__ = 1; sym1__ <= Nc; ++sym1__) {
          current_statement__ = 56;
          for (int sym2__ = 1; sym2__ <= K; ++sym2__) {
            current_statement__ = 56;
            assign(X,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              X_flat__[(pos__ - 1)], "assigning variable X");
            current_statement__ = 56;
            pos__ = (pos__ + 1);}}
      }
      current_statement__ = 57;
      context__.validate_dims("data initialization","prior_hypermean_fam",
          "int",context__.to_vec());
      prior_hypermean_fam = std::numeric_limits<int>::min();
      
      current_statement__ = 57;
      prior_hypermean_fam = context__.vals_i("prior_hypermean_fam")[(1 - 1)];
      current_statement__ = 58;
      context__.validate_dims("data initialization","prior_hypersd_fam",
          "int",context__.to_vec());
      prior_hypersd_fam = std::numeric_limits<int>::min();
      
      current_statement__ = 58;
      prior_hypersd_fam = context__.vals_i("prior_hypersd_fam")[(1 - 1)];
      current_statement__ = 59;
      context__.validate_dims("data initialization","prior_beta_fam","int",
          context__.to_vec());
      prior_beta_fam = std::numeric_limits<int>::min();
      
      current_statement__ = 59;
      prior_beta_fam = context__.vals_i("prior_beta_fam")[(1 - 1)];
      current_statement__ = 60;
      context__.validate_dims("data initialization","prior_hypermean_val",
          "double",context__.to_vec(3));
      prior_hypermean_val = Eigen::Matrix<double, -1, 1>(3);
      stan::math::fill(prior_hypermean_val, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> prior_hypermean_val_flat__;
        current_statement__ = 60;
        assign(prior_hypermean_val_flat__, nil_index_list(),
          context__.vals_r("prior_hypermean_val"),
          "assigning variable prior_hypermean_val_flat__");
        current_statement__ = 60;
        pos__ = 1;
        current_statement__ = 60;
        for (int sym1__ = 1; sym1__ <= 3; ++sym1__) {
          current_statement__ = 60;
          assign(prior_hypermean_val,
            cons_list(index_uni(sym1__), nil_index_list()),
            prior_hypermean_val_flat__[(pos__ - 1)],
            "assigning variable prior_hypermean_val");
          current_statement__ = 60;
          pos__ = (pos__ + 1);}
      }
      current_statement__ = 61;
      context__.validate_dims("data initialization","prior_hypersd_val",
          "double",context__.to_vec(3));
      prior_hypersd_val = Eigen::Matrix<double, -1, 1>(3);
      stan::math::fill(prior_hypersd_val, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> prior_hypersd_val_flat__;
        current_statement__ = 61;
        assign(prior_hypersd_val_flat__, nil_index_list(),
          context__.vals_r("prior_hypersd_val"),
          "assigning variable prior_hypersd_val_flat__");
        current_statement__ = 61;
        pos__ = 1;
        current_statement__ = 61;
        for (int sym1__ = 1; sym1__ <= 3; ++sym1__) {
          current_statement__ = 61;
          assign(prior_hypersd_val,
            cons_list(index_uni(sym1__), nil_index_list()),
            prior_hypersd_val_flat__[(pos__ - 1)],
            "assigning variable prior_hypersd_val");
          current_statement__ = 61;
          pos__ = (pos__ + 1);}
      }
      current_statement__ = 62;
      context__.validate_dims("data initialization","prior_beta_val",
          "double",context__.to_vec(3));
      prior_beta_val = Eigen::Matrix<double, -1, 1>(3);
      stan::math::fill(prior_beta_val, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> prior_beta_val_flat__;
        current_statement__ = 62;
        assign(prior_beta_val_flat__, nil_index_list(),
          context__.vals_r("prior_beta_val"),
          "assigning variable prior_beta_val_flat__");
        current_statement__ = 62;
        pos__ = 1;
        current_statement__ = 62;
        for (int sym1__ = 1; sym1__ <= 3; ++sym1__) {
          current_statement__ = 62;
          assign(prior_beta_val,
            cons_list(index_uni(sym1__), nil_index_list()),
            prior_beta_val_flat__[(pos__ - 1)],
            "assigning variable prior_beta_val");
          current_statement__ = 62;
          pos__ = (pos__ + 1);}
      }
      current_statement__ = 63;
      context__.validate_dims("data initialization","K_test","int",
          context__.to_vec());
      K_test = std::numeric_limits<int>::min();
      
      current_statement__ = 63;
      K_test = context__.vals_i("K_test")[(1 - 1)];
      current_statement__ = 63;
      current_statement__ = 63;
      check_greater_or_equal(function__, "K_test", K_test, 0);
      current_statement__ = 64;
      validate_non_negative_index("test_theta_hat_k", "K_test", K_test);
      current_statement__ = 65;
      context__.validate_dims("data initialization","test_theta_hat_k",
          "double",context__.to_vec(K_test));
      test_theta_hat_k = Eigen::Matrix<double, -1, 1>(K_test);
      stan::math::fill(test_theta_hat_k, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> test_theta_hat_k_flat__;
        current_statement__ = 65;
        assign(test_theta_hat_k_flat__, nil_index_list(),
          context__.vals_r("test_theta_hat_k"),
          "assigning variable test_theta_hat_k_flat__");
        current_statement__ = 65;
        pos__ = 1;
        current_statement__ = 65;
        for (int sym1__ = 1; sym1__ <= K_test; ++sym1__) {
          current_statement__ = 65;
          assign(test_theta_hat_k,
            cons_list(index_uni(sym1__), nil_index_list()),
            test_theta_hat_k_flat__[(pos__ - 1)],
            "assigning variable test_theta_hat_k");
          current_statement__ = 65;
          pos__ = (pos__ + 1);}
      }
      current_statement__ = 66;
      validate_non_negative_index("test_se_theta_k", "K_test", K_test);
      current_statement__ = 67;
      context__.validate_dims("data initialization","test_se_theta_k",
          "double",context__.to_vec(K_test));
      test_se_theta_k = Eigen::Matrix<double, -1, 1>(K_test);
      stan::math::fill(test_se_theta_k, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> test_se_theta_k_flat__;
        current_statement__ = 67;
        assign(test_se_theta_k_flat__, nil_index_list(),
          context__.vals_r("test_se_theta_k"),
          "assigning variable test_se_theta_k_flat__");
        current_statement__ = 67;
        pos__ = 1;
        current_statement__ = 67;
        for (int sym1__ = 1; sym1__ <= K_test; ++sym1__) {
          current_statement__ = 67;
          assign(test_se_theta_k,
            cons_list(index_uni(sym1__), nil_index_list()),
            test_se_theta_k_flat__[(pos__ - 1)],
            "assigning variable test_se_theta_k");
          current_statement__ = 67;
          pos__ = (pos__ + 1);}
      }
      current_statement__ = 67;
      for (int sym1__ = 1; sym1__ <= K_test; ++sym1__) {
        current_statement__ = 67;
        current_statement__ = 67;
        check_greater_or_equal(function__, "test_se_theta_k[sym1__]",
                               test_se_theta_k[(sym1__ - 1)], 0);}
      current_statement__ = 68;
      validate_non_negative_index("X_test", "K_test", K_test);
      current_statement__ = 69;
      validate_non_negative_index("X_test", "Nc", Nc);
      current_statement__ = 70;
      context__.validate_dims("data initialization","X_test","double",
          context__.to_vec(K_test, Nc));
      X_test = Eigen::Matrix<double, -1, -1>(K_test, Nc);
      stan::math::fill(X_test, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> X_test_flat__;
        current_statement__ = 70;
        assign(X_test_flat__, nil_index_list(), context__.vals_r("X_test"),
          "assigning variable X_test_flat__");
        current_statement__ = 70;
        pos__ = 1;
        current_statement__ = 70;
        for (int sym1__ = 1; sym1__ <= Nc; ++sym1__) {
          current_statement__ = 70;
          for (int sym2__ = 1; sym2__ <= K_test; ++sym2__) {
            current_statement__ = 70;
            assign(X_test,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              X_test_flat__[(pos__ - 1)], "assigning variable X_test");
            current_statement__ = 70;
            pos__ = (pos__ + 1);}}
      }
      current_statement__ = 71;
      K_pooled = std::numeric_limits<int>::min();
      
      current_statement__ = 71;
      K_pooled = (logical_eq(pooling_type, 2) ? 0 : K);
      current_statement__ = 72;
      validate_non_negative_index("test_var_theta_k", "K_test", K_test);
      current_statement__ = 73;
      test_var_theta_k = Eigen::Matrix<double, -1, 1>(K_test);
      stan::math::fill(test_var_theta_k, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 73;
      assign(test_var_theta_k, nil_index_list(),
        elt_multiply(test_se_theta_k, test_se_theta_k),
        "assigning variable test_var_theta_k");
      current_statement__ = 74;
      mu_1dim__ = std::numeric_limits<int>::min();
      
      current_statement__ = 74;
      mu_1dim__ = logical_neq(pooling_type, 0);
      current_statement__ = 74;
      validate_non_negative_index("mu", "pooling_type != 0", mu_1dim__);
      current_statement__ = 75;
      tau_1dim__ = std::numeric_limits<int>::min();
      
      current_statement__ = 75;
      tau_1dim__ = logical_eq(pooling_type, 1);
      current_statement__ = 75;
      validate_non_negative_index("tau", "pooling_type == 1", tau_1dim__);
      current_statement__ = 76;
      validate_non_negative_index("eta", "K_pooled", K_pooled);
      current_statement__ = 77;
      validate_non_negative_index("beta", "Nc", Nc);
      current_statement__ = 78;
      validate_non_negative_index("theta_k", "K_pooled", K_pooled);
      current_statement__ = 79;
      logpd_1dim__ = std::numeric_limits<int>::min();
      
      current_statement__ = 79;
      logpd_1dim__ = logical_gt(K_test, 0);
      current_statement__ = 79;
      validate_non_negative_index("logpd", "K_test > 0", logpd_1dim__);
      current_statement__ = 80;
      validate_non_negative_index("fe_k_test", "K_test", K_test);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    num_params_r__ = 0U;
    
    try {
      num_params_r__ += mu_1dim__;
      num_params_r__ += tau_1dim__;
      num_params_r__ += K_pooled;
      num_params_r__ += Nc;
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
  }
  template <bool propto__, bool jacobian__, typename VecR, typename VecI, stan::require_vector_like_t<VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline stan::scalar_type_t<VecR> log_prob_impl(VecR& params_r__,
                                                 VecI& params_i__,
                                                 std::ostream* pstream__ = nullptr) const {
    using T__ = stan::scalar_type_t<VecR>;
    using local_scalar_t__ = T__;
    T__ lp__(0.0);
    stan::math::accumulator<T__> lp_accum__;
    static const char* function__ = "model_rubin_namespace::log_prob";
(void) function__;  // suppress unused var warning
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      std::vector<local_scalar_t__> mu;
      mu = std::vector<local_scalar_t__>(mu_1dim__, DUMMY_VAR__);
      
      current_statement__ = 1;
      for (int sym1__ = 1; sym1__ <= mu_1dim__; ++sym1__) {
        current_statement__ = 1;
        assign(mu, cons_list(index_uni(sym1__), nil_index_list()),
          in__.scalar(), "assigning variable mu");}
      std::vector<local_scalar_t__> tau;
      tau = std::vector<local_scalar_t__>(tau_1dim__, DUMMY_VAR__);
      
      current_statement__ = 2;
      for (int sym1__ = 1; sym1__ <= tau_1dim__; ++sym1__) {
        current_statement__ = 2;
        assign(tau, cons_list(index_uni(sym1__), nil_index_list()),
          in__.scalar(), "assigning variable tau");}
      current_statement__ = 2;
      for (int sym1__ = 1; sym1__ <= tau_1dim__; ++sym1__) {
        current_statement__ = 2;
        if (jacobian__) {
          current_statement__ = 2;
          assign(tau, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lb_constrain(tau[(sym1__ - 1)], 0, lp__),
            "assigning variable tau");
        } else {
          current_statement__ = 2;
          assign(tau, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lb_constrain(tau[(sym1__ - 1)], 0),
            "assigning variable tau");
        }}
      Eigen::Matrix<local_scalar_t__, -1, 1> eta;
      eta = Eigen::Matrix<local_scalar_t__, -1, 1>(K_pooled);
      stan::math::fill(eta, DUMMY_VAR__);
      
      current_statement__ = 3;
      eta = in__.vector(K_pooled);
      Eigen::Matrix<local_scalar_t__, -1, 1> beta;
      beta = Eigen::Matrix<local_scalar_t__, -1, 1>(Nc);
      stan::math::fill(beta, DUMMY_VAR__);
      
      current_statement__ = 4;
      beta = in__.vector(Nc);
      Eigen::Matrix<local_scalar_t__, -1, 1> theta_k;
      theta_k = Eigen::Matrix<local_scalar_t__, -1, 1>(K_pooled);
      stan::math::fill(theta_k, DUMMY_VAR__);
      
      current_statement__ = 9;
      if (logical_eq(pooling_type, 0)) {
        current_statement__ = 8;
        assign(theta_k, nil_index_list(), eta, "assigning variable theta_k");
      } else {
        current_statement__ = 7;
        if (logical_eq(pooling_type, 1)) {
          current_statement__ = 6;
          assign(theta_k, nil_index_list(),
            add(mu[(1 - 1)], multiply(eta, tau[(1 - 1)])),
            "assigning variable theta_k");
        } 
      }
      {
        current_statement__ = 24;
        validate_non_negative_index("fe_k", "K", K);
        Eigen::Matrix<local_scalar_t__, -1, 1> fe_k;
        fe_k = Eigen::Matrix<local_scalar_t__, -1, 1>(K);
        stan::math::fill(fe_k, DUMMY_VAR__);
        
        current_statement__ = 33;
        if (logical_gt(K, 0)) {
          current_statement__ = 31;
          if (logical_eq(Nc, 0)) {
            current_statement__ = 29;
            assign(fe_k, nil_index_list(), rep_vector(0.0, K),
              "assigning variable fe_k");
          } else {
            current_statement__ = 26;
            assign(fe_k, nil_index_list(), multiply(X, beta),
              "assigning variable fe_k");
            current_statement__ = 27;
            lp_accum__.add(
              vecprior_lpdf<propto__>(beta, prior_beta_fam,
                prior_beta_val, pstream__));
          }
        } 
        current_statement__ = 46;
        if (logical_eq(pooling_type, 0)) {
          current_statement__ = 43;
          lp_accum__.add(
            vecprior_lpdf<propto__>(eta, prior_hypermean_fam,
              prior_hypermean_val, pstream__));
          current_statement__ = 44;
          lp_accum__.add(
            normal_lpdf<propto__>(theta_hat_k, add(theta_k, fe_k),
              se_theta_k));
        } else {
          current_statement__ = 42;
          if (logical_eq(pooling_type, 1)) {
            current_statement__ = 37;
            lp_accum__.add(
              realprior_lpdf<propto__>(mu[(1 - 1)], prior_hypermean_fam,
                prior_hypermean_val, pstream__));
            current_statement__ = 38;
            lp_accum__.add(
              realprior_lpdf<propto__>(tau[(1 - 1)], prior_hypersd_fam,
                prior_hypersd_val, pstream__));
            current_statement__ = 39;
            lp_accum__.add(normal_lpdf<propto__>(eta, 0, 1));
            current_statement__ = 40;
            lp_accum__.add(
              normal_lpdf<propto__>(theta_hat_k, add(theta_k, fe_k),
                se_theta_k));
          } else {
            current_statement__ = 34;
            lp_accum__.add(
              realprior_lpdf<propto__>(mu[(1 - 1)], prior_hypermean_fam,
                prior_hypermean_val, pstream__));
            current_statement__ = 35;
            lp_accum__.add(
              normal_lpdf<propto__>(theta_hat_k, add(mu[(1 - 1)], fe_k),
                se_theta_k));
          }
        }
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    lp_accum__.add(lp__);
    return lp_accum__.sum();
    } // log_prob_impl() 
    
  template <typename RNG, typename VecR, typename VecI, typename VecVar, stan::require_vector_like_vt<std::is_floating_point, VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr, stan::require_std_vector_vt<std::is_floating_point, VecVar>* = nullptr>
  inline void write_array_impl(RNG& base_rng__, VecR& params_r__,
                               VecI& params_i__, VecVar& vars__,
                               const bool emit_transformed_parameters__ = true,
                               const bool emit_generated_quantities__ = true,
                               std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.resize(0);
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    static const char* function__ = "model_rubin_namespace::write_array";
(void) function__;  // suppress unused var warning
    (void) function__;  // suppress unused var warning
    double lp__ = 0.0;
    (void) lp__;  // dummy to suppress unused var warning
    stan::math::accumulator<double> lp_accum__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      std::vector<double> mu;
      mu = std::vector<double>(mu_1dim__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 1;
      for (int sym1__ = 1; sym1__ <= mu_1dim__; ++sym1__) {
        current_statement__ = 1;
        assign(mu, cons_list(index_uni(sym1__), nil_index_list()),
          in__.scalar(), "assigning variable mu");}
      std::vector<double> tau;
      tau = std::vector<double>(tau_1dim__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 2;
      for (int sym1__ = 1; sym1__ <= tau_1dim__; ++sym1__) {
        current_statement__ = 2;
        assign(tau, cons_list(index_uni(sym1__), nil_index_list()),
          in__.scalar(), "assigning variable tau");}
      current_statement__ = 2;
      for (int sym1__ = 1; sym1__ <= tau_1dim__; ++sym1__) {
        current_statement__ = 2;
        assign(tau, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lb_constrain(tau[(sym1__ - 1)], 0),
          "assigning variable tau");}
      Eigen::Matrix<double, -1, 1> eta;
      eta = Eigen::Matrix<double, -1, 1>(K_pooled);
      stan::math::fill(eta, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 3;
      eta = in__.vector(K_pooled);
      Eigen::Matrix<double, -1, 1> beta;
      beta = Eigen::Matrix<double, -1, 1>(Nc);
      stan::math::fill(beta, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 4;
      beta = in__.vector(Nc);
      Eigen::Matrix<double, -1, 1> theta_k;
      theta_k = Eigen::Matrix<double, -1, 1>(K_pooled);
      stan::math::fill(theta_k, std::numeric_limits<double>::quiet_NaN());
      
      for (int sym1__ = 1; sym1__ <= mu_1dim__; ++sym1__) {
        vars__.emplace_back(mu[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= tau_1dim__; ++sym1__) {
        vars__.emplace_back(tau[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= K_pooled; ++sym1__) {
        vars__.emplace_back(eta[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= Nc; ++sym1__) {
        vars__.emplace_back(beta[(sym1__ - 1)]);}
      if (logical_negation((primitive_value(emit_transformed_parameters__) ||
            primitive_value(emit_generated_quantities__)))) {
        return ;
      } 
      current_statement__ = 9;
      if (logical_eq(pooling_type, 0)) {
        current_statement__ = 8;
        assign(theta_k, nil_index_list(), eta, "assigning variable theta_k");
      } else {
        current_statement__ = 7;
        if (logical_eq(pooling_type, 1)) {
          current_statement__ = 6;
          assign(theta_k, nil_index_list(),
            add(mu[(1 - 1)], multiply(eta, tau[(1 - 1)])),
            "assigning variable theta_k");
        } 
      }
      if (emit_transformed_parameters__) {
        for (int sym1__ = 1; sym1__ <= K_pooled; ++sym1__) {
          vars__.emplace_back(theta_k[(sym1__ - 1)]);}
      } 
      if (logical_negation(emit_generated_quantities__)) {
        return ;
      } 
      std::vector<double> logpd;
      logpd = std::vector<double>(logpd_1dim__, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, 1> fe_k_test;
      fe_k_test = Eigen::Matrix<double, -1, 1>(K_test);
      stan::math::fill(fe_k_test, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 23;
      if (logical_gt(K_test, 0)) {
        current_statement__ = 14;
        if (logical_eq(Nc, 0)) {
          current_statement__ = 13;
          assign(fe_k_test, nil_index_list(), rep_vector(0.0, K_test),
            "assigning variable fe_k_test");
        } else {
          current_statement__ = 12;
          assign(fe_k_test, nil_index_list(), multiply(X_test, beta),
            "assigning variable fe_k_test");
        }
        current_statement__ = 15;
        assign(logpd, cons_list(index_uni(1), nil_index_list()), 0,
          "assigning variable logpd");
        current_statement__ = 21;
        for (int k = 1; k <= K_test; ++k) {
          current_statement__ = 17;
          if (logical_eq(pooling_type, 1)) {
            current_statement__ = 16;
            assign(logpd, cons_list(index_uni(1), nil_index_list()),
              (logpd[(1 - 1)] +
                normal_lpdf<false>(test_theta_hat_k[(k - 1)],
                  add(mu[(1 - 1)], fe_k_test),
                  stan::math::sqrt(
                    add(pow(tau[(1 - 1)], 2), test_var_theta_k)))),
              "assigning variable logpd");
          } 
          current_statement__ = 19;
          if (logical_eq(pooling_type, 2)) {
            current_statement__ = 18;
            assign(logpd, cons_list(index_uni(1), nil_index_list()),
              (logpd[(1 - 1)] +
                normal_lpdf<false>(test_theta_hat_k[(k - 1)],
                  add(mu[(1 - 1)], fe_k_test), test_se_theta_k)),
              "assigning variable logpd");
          } }
      } 
      for (int sym1__ = 1; sym1__ <= logpd_1dim__; ++sym1__) {
        vars__.emplace_back(logpd[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= K_test; ++sym1__) {
        vars__.emplace_back(fe_k_test[(sym1__ - 1)]);}
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // write_array_impl() 
    
  template <typename VecVar, typename VecI, stan::require_std_vector_t<VecVar>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline void transform_inits_impl(const stan::io::var_context& context__,
                                   VecI& params_i__, VecVar& vars__,
                                   std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.clear();
    vars__.reserve(num_params_r__);
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      std::vector<double> mu;
      mu = std::vector<double>(mu_1dim__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 1;
      assign(mu, nil_index_list(), context__.vals_r("mu"),
        "assigning variable mu");
      std::vector<double> tau;
      tau = std::vector<double>(tau_1dim__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 2;
      assign(tau, nil_index_list(), context__.vals_r("tau"),
        "assigning variable tau");
      std::vector<double> tau_free__;
      tau_free__ = std::vector<double>(tau_1dim__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 2;
      for (int sym1__ = 1; sym1__ <= tau_1dim__; ++sym1__) {
        current_statement__ = 2;
        assign(tau_free__, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lb_free(tau[(sym1__ - 1)], 0),
          "assigning variable tau_free__");}
      Eigen::Matrix<double, -1, 1> eta;
      eta = Eigen::Matrix<double, -1, 1>(K_pooled);
      stan::math::fill(eta, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> eta_flat__;
        current_statement__ = 3;
        assign(eta_flat__, nil_index_list(), context__.vals_r("eta"),
          "assigning variable eta_flat__");
        current_statement__ = 3;
        pos__ = 1;
        current_statement__ = 3;
        for (int sym1__ = 1; sym1__ <= K_pooled; ++sym1__) {
          current_statement__ = 3;
          assign(eta, cons_list(index_uni(sym1__), nil_index_list()),
            eta_flat__[(pos__ - 1)], "assigning variable eta");
          current_statement__ = 3;
          pos__ = (pos__ + 1);}
      }
      Eigen::Matrix<double, -1, 1> beta;
      beta = Eigen::Matrix<double, -1, 1>(Nc);
      stan::math::fill(beta, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> beta_flat__;
        current_statement__ = 4;
        assign(beta_flat__, nil_index_list(), context__.vals_r("beta"),
          "assigning variable beta_flat__");
        current_statement__ = 4;
        pos__ = 1;
        current_statement__ = 4;
        for (int sym1__ = 1; sym1__ <= Nc; ++sym1__) {
          current_statement__ = 4;
          assign(beta, cons_list(index_uni(sym1__), nil_index_list()),
            beta_flat__[(pos__ - 1)], "assigning variable beta");
          current_statement__ = 4;
          pos__ = (pos__ + 1);}
      }
      for (int sym1__ = 1; sym1__ <= mu_1dim__; ++sym1__) {
        vars__.emplace_back(mu[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= tau_1dim__; ++sym1__) {
        vars__.emplace_back(tau_free__[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= K_pooled; ++sym1__) {
        vars__.emplace_back(eta[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= Nc; ++sym1__) {
        vars__.emplace_back(beta[(sym1__ - 1)]);}
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // transform_inits_impl() 
    
  inline void get_param_names(std::vector<std::string>& names__) const {
    
    names__.clear();
    names__.emplace_back("mu");
    names__.emplace_back("tau");
    names__.emplace_back("eta");
    names__.emplace_back("beta");
    names__.emplace_back("theta_k");
    names__.emplace_back("logpd");
    names__.emplace_back("fe_k_test");
    } // get_param_names() 
    
  inline void get_dims(std::vector<std::vector<size_t>>& dimss__) const {
    dimss__.clear();
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(mu_1dim__)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(tau_1dim__)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(K_pooled)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(Nc)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(K_pooled)});
    
    dimss__.emplace_back(std::vector<size_t>{
                                             static_cast<size_t>(logpd_1dim__)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(K_test)});
    
    } // get_dims() 
    
  inline void constrained_param_names(
                                      std::vector<std::string>& param_names__,
                                      bool emit_transformed_parameters__ = true,
                                      bool emit_generated_quantities__ = true) const
    final {
    
    for (int sym1__ = 1; sym1__ <= mu_1dim__; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "mu" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= tau_1dim__; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "tau" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= K_pooled; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "eta" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= Nc; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "beta" + '.' + std::to_string(sym1__));
      }}
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= K_pooled; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "theta_k" + '.' + std::to_string(sym1__));
        }}
    }
    
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= logpd_1dim__; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "logpd" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= K_test; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "fe_k_test" + '.' + std::to_string(sym1__));
        }}
    }
    
    } // constrained_param_names() 
    
  inline void unconstrained_param_names(
                                        std::vector<std::string>& param_names__,
                                        bool emit_transformed_parameters__ = true,
                                        bool emit_generated_quantities__ = true) const
    final {
    
    for (int sym1__ = 1; sym1__ <= mu_1dim__; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "mu" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= tau_1dim__; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "tau" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= K_pooled; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "eta" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= Nc; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "beta" + '.' + std::to_string(sym1__));
      }}
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= K_pooled; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "theta_k" + '.' + std::to_string(sym1__));
        }}
    }
    
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= logpd_1dim__; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "logpd" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= K_test; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "fe_k_test" + '.' + std::to_string(sym1__));
        }}
    }
    
    } // unconstrained_param_names() 
    
  inline std::string get_constrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"mu\",\"type\":{\"name\":\"array\",\"length\":" << mu_1dim__ << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"tau\",\"type\":{\"name\":\"array\",\"length\":" << tau_1dim__ << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"eta\",\"type\":{\"name\":\"vector\",\"length\":" << K_pooled << "},\"block\":\"parameters\"},{\"name\":\"beta\",\"type\":{\"name\":\"vector\",\"length\":" << Nc << "},\"block\":\"parameters\"},{\"name\":\"theta_k\",\"type\":{\"name\":\"vector\",\"length\":" << K_pooled << "},\"block\":\"transformed_parameters\"},{\"name\":\"logpd\",\"type\":{\"name\":\"array\",\"length\":" << logpd_1dim__ << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"generated_quantities\"},{\"name\":\"fe_k_test\",\"type\":{\"name\":\"vector\",\"length\":" << K_test << "},\"block\":\"generated_quantities\"}]";
    return s__.str();
    } // get_constrained_sizedtypes() 
    
  inline std::string get_unconstrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"mu\",\"type\":{\"name\":\"array\",\"length\":" << mu_1dim__ << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"tau\",\"type\":{\"name\":\"array\",\"length\":" << tau_1dim__ << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"eta\",\"type\":{\"name\":\"vector\",\"length\":" << K_pooled << "},\"block\":\"parameters\"},{\"name\":\"beta\",\"type\":{\"name\":\"vector\",\"length\":" << Nc << "},\"block\":\"parameters\"},{\"name\":\"theta_k\",\"type\":{\"name\":\"vector\",\"length\":" << K_pooled << "},\"block\":\"transformed_parameters\"},{\"name\":\"logpd\",\"type\":{\"name\":\"array\",\"length\":" << logpd_1dim__ << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"generated_quantities\"},{\"name\":\"fe_k_test\",\"type\":{\"name\":\"vector\",\"length\":" << K_test << "},\"block\":\"generated_quantities\"}]";
    return s__.str();
    } // get_unconstrained_sizedtypes() 
    
  
    // Begin method overload boilerplate
    template <typename RNG>
    inline void write_array(RNG& base_rng,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                            const bool emit_transformed_parameters = true,
                            const bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      std::vector<double> vars_vec(vars.size());
      std::vector<int> params_i;
      write_array_impl(base_rng, params_r, params_i, vars_vec,
          emit_transformed_parameters, emit_generated_quantities, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i) {
        vars.coeffRef(i) = vars_vec[i];
      }
    }
    template <typename RNG>
    inline void write_array(RNG& base_rng, std::vector<double>& params_r,
                            std::vector<int>& params_i,
                            std::vector<double>& vars,
                            bool emit_transformed_parameters = true,
                            bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      write_array_impl(base_rng, params_r, params_i, vars, emit_transformed_parameters, emit_generated_quantities, pstream);
    }
    template <bool propto__, bool jacobian__, typename T_>
    inline T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
                       std::ostream* pstream = nullptr) const {
      Eigen::Matrix<int, -1, 1> params_i;
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
    template <bool propto__, bool jacobian__, typename T__>
    inline T__ log_prob(std::vector<T__>& params_r,
                        std::vector<int>& params_i,
                        std::ostream* pstream = nullptr) const {
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
  
    inline void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream = nullptr) const final {
      std::vector<double> params_r_vec(params_r.size());
      std::vector<int> params_i;
      transform_inits_impl(context, params_i, params_r_vec, pstream);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i) {
        params_r.coeffRef(i) = params_r_vec[i];
      }
    }
    inline void transform_inits(const stan::io::var_context& context,
                                std::vector<int>& params_i,
                                std::vector<double>& vars,
                                std::ostream* pstream = nullptr) const final {
      transform_inits_impl(context, params_i, vars, pstream);
    }        
};
}
using stan_model = model_rubin_namespace::model_rubin;
#ifndef USING_R
// Boilerplate
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
stan::math::profile_map& get_stan_profile_data() {
  return model_rubin_namespace::profiles__;
}
#endif
#endif
