% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nba-per-game-stats-per-36.R
\name{NBAPerGameStatisticsPer36Min}
\alias{NBAPerGameStatisticsPer36Min}
\title{NBA Player Statistics For a Given Season per 36 Minutes}
\usage{
NBAPerGameStatisticsPer36Min(season = 2018)
}
\arguments{
\item{season}{A numeric year}
}
\value{
An object of class tbl_df
}
\description{
This function returns all player statistics on a per game basis (per 36 min)
from an NBA season on basketball-reference.com.  See an example
table at:
http://www.basketball-reference.com/leagues/NBA_2018_per_minute.html
}
\examples{
library(magrittr)

players <- NBAPerGameStatisticsPer36Min(season = 2018)
players

players \%>\%
  dplyr::filter(mp > 20, pos \%in\% c("SF")) \%>\%
  dplyr::select(player, link) \%>\%
  dplyr::distinct()

}
