% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bam_classes.R
\docType{class}
\name{setA-class}
\alias{setA-class}
\alias{setA}
\alias{A-class}
\title{Class for the A (Abiotic) Set of BAM Diagram}
\value{
An object of class setA
showClass("setA")
}
\description{
Represents the abiotic component (environmental suitability) in the BAM framework.
Contains raster-based niche models and their sparse matrix representations.
}
\section{Slots}{

\describe{
\item{\code{niche_model}}{A \code{RasterLayer} or \code{RasterStack} representing the
environmental suitability model (binary or continuous)}

\item{\code{suit_threshold}}{Numeric value used to binarize continuous models}

\item{\code{cellIDs}}{Numeric vector of raster cell IDs with non-NA values}

\item{\code{suit_values}}{Numeric vector of suitability values for continuous models}

\item{\code{sparse_model}}{A sparse matrix (\code{dgCMatrix}) representation of the niche model}
}}

\section{Validity}{

The \code{niche_model} slot must be either a \code{RasterLayer} or \code{RasterStack}.
}

\seealso{
\code{\link{model2sparse}}, \code{\link{setM-class}}
}
\author{
Luis Osorio-Olvera & Jorge Soberón
}
