% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pred_means_new_initials_GS.R
\name{pred_means_bbma_new_initials_GS}
\alias{pred_means_bbma_new_initials_GS}
\title{Predictions for bart-bma output obtained from a Gibbs sampler}
\usage{
pred_means_bbma_new_initials_GS(
  object,
  num_iter,
  burnin,
  newdata = NULL,
  update_resids = 1,
  trainingdata
)
}
\arguments{
\item{object}{bartBMA object obtained from function bartBMA}

\item{num_iter}{Total number of iterations of the Gibbs sampler (including burn-in).}

\item{burnin}{Number of burn-on iterations of the Gibbs sampler.}

\item{newdata}{Test data for which predictions are to be produced. Default = NULL. If NULL, then produces prediction intervals for training data if no test data was used in producing the bartBMA object, or produces prediction intervals for the original test data if test data was used in producing the bartBMA object.}

\item{update_resids}{Option for whether to update the partial residuals in the gibbs sampler. If equal to 1, updates partial residuals, if equal to zero, does not update partial residuals. The defaullt setting is to update the partial residua;s.}

\item{trainingdata}{The matrix of training data.}
}
\value{
The output is a vector of predictions.
}
\description{
This function produces predictions from BART-BMA by post-hoc Gibbs-sampling from the full conditionals of the terminal node parameters and the variance of the error term. See Hernandez et al. (2018) Appendix D for details.
}
\examples{
set.seed(100)
#simulate some data
N <- 100
p<- 100
epsilon <- rnorm(N)
xcov <- matrix(runif(N*p), nrow=N)
y <- sin(pi*xcov[,1]*xcov[,2]) + 20*(xcov[,3]-0.5)^2+10*xcov[,4]+5*xcov[,5]+epsilon
epsilontest <- rnorm(N)
xcovtest <- matrix(runif(N*p), nrow=N)
ytest <- sin(pi*xcovtest[,1]*xcovtest[,2]) + 20*(xcovtest[,3]-0.5)^2+10*xcovtest[,4]+
  5*xcovtest[,5]+epsilontest

#Train the object 
bart_bma_example <- bartBMA(x.train = xcov,y.train=y,x.test=xcovtest,zero_split = 1, 
                            only_max_num_trees = 1,split_rule_node = 0)
#Obtain the prediction intervals
pred_means_bbma_new_initials_GS(bart_bma_example,1000,100,newdata=NULL,update_resids=1,xcovtest)
}
