% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Tidy_names_types_factors.R
\name{apply_data_dictionary}
\alias{apply_data_dictionary}
\title{Clean column names, types and levels}
\usage{
apply_data_dictionary(data, data_dictionary)
}
\arguments{
\item{data}{data.frame to be cleaned}

\item{data_dictionary}{data.frame with the following columns:
\itemize{
\item old_column_name : character with the old column name
\item new_data_type : character denoting the tidy data type. Supported types are:
\itemize{
\item character
\item integer
\item float
\item factor
\item date (can only confirm correct datatype assignment, not coerce other types into date)
}
\item new_column_name : tidy column name. Can be left blank to keep the old column name
\item coding (factor columns only) : character denoting old value (key) and new value (value) in a standardised fashion:
\itemize{
\item key-value pairs are separated from other key-value-pairs by a comma (",")
\item key and value of the same pair are separated by an equal sign ("=")
\item quotations around individual keys and values are recommended for clarity, but do not affect functionality.
\item all values will be coerced to type character, with the exception of "NA" being parsed as type NA
\item using "default" as a key will assign the specified value to all current values that do not match any of the specified keys, including NA
\item example coding: "'key1' = 'val1', 'key2' = 'val2', 'default' = NA"
\item if no coding is specified for a column, the coding remains unchanged
}
\item Optional other columns (do not affect behaviour)
}}
}
\value{
clean data.frame
}
\description{
Use a data dictionary data.frame to apply the follwowing tidying steps to your data.frame:
\itemize{
\item Remove superfluous columns
\item Rename columns
\item Ensure/coerce correct data type for each column
\item Assign factorial levels, including renaming and grouping
}
}
\author{
J. Peter Marquardt
}
