% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkArgument.R
\name{checkArgument}
\alias{checkArgument}
\title{Perform basic checks on a function argument.}
\usage{
checkArgument(
  argumentCheckMode,
  checkDataTypes,
  className,
  methodName,
  argumentValue,
  isMissing,
  allowMissing = FALSE,
  allowNull = FALSE,
  allowedClasses = NULL,
  mustBeAtomic = FALSE,
  allowedListElementClasses = NULL,
  listElementsMustBeAtomic = FALSE,
  allowedValues = NULL,
  minValue = NULL,
  maxValue = NULL,
  maxLength = NULL
)
}
\arguments{
\item{argumentCheckMode}{A number between 0 and 4 specifying the checks to
perform.}

\item{checkDataTypes}{A logical value specifying whether the data types
should be checked when argumentCheckMode=3}

\item{className}{The name of the calling class, for inclusion in error
messages.}

\item{methodName}{The name of the calling method, for inclusion in error
messages.}

\item{argumentValue}{The value to check.}

\item{isMissing}{Whether the argument is missing in the calling function.}

\item{allowMissing}{Whether missing values are permitted.}

\item{allowNull}{Whether null values are permitted.}

\item{allowedClasses}{The names of the allowed classes for argumentValue.}

\item{mustBeAtomic}{Whether the argument value must be atomic.}

\item{allowedListElementClasses}{For argument values that are lists(), the
names of the allowed classes for the elements in the list.}

\item{listElementsMustBeAtomic}{For argument values that are lists(), whether
the list elements must be atomic.}

\item{allowedValues}{For argument values that must be one value from a set
list, the list of allowed values.}

\item{minValue}{For numerical values, the lowest allowed value.}

\item{maxValue}{For numerical values, the highest allowed value.}

\item{maxLength}{For character values, the maximum allowed length (in
characters) of the value.}
}
\value{
No return value.  If invalid values are encountered, the
  \code{stop()} function is used to interrupt execution.
}
\description{
\code{checkArgument} is a utility function that provides basic assurances
about function argument values and generates standardised error messages when
invalid values are encountered.  This function should not be used outside the
basictabler package.
}
