% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update.r
\name{update_p0}
\alias{update_p0}
\title{Update Full Bayes results with different p0 values}
\usage{
update_p0(res, p0 = 0.15, alternative = "greater")
}
\arguments{
\item{res}{the result of an mem analysis.}

\item{p0}{the null response rate for the poster probability calculation
(default 0.15).}

\item{alternative}{the alternative case definition (default greater)}
}
\description{
After running either `mem_mcmc` or `mem_exact`, the
test can be updated without rerunning the entire analysis. This function
provides updating of both the null response rate along with the
alternative rerunning relevant test.
}
\examples{
\dontrun{
# Create an MEM analysis of the Vemurafenib trial data.
data(vemu_wide)

mem_analysis <- mem_exact(
  vemu_wide$responders,
  vemu_wide$evaluable,
  vemu_wide$baskets
)

# Update the null from p0 = 0.15 the default, to p = 0.25.
update_p0(mem_analysis, 0.20)
}
}
