% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjust_lambda.R
\name{adjust_lambda}
\alias{adjust_lambda}
\alias{adjust_lambda,OneStageBasket-method}
\alias{adjust_lambda,TwoStageBasket-method}
\title{Adjust Lambda}
\usage{
adjust_lambda(design, ...)

\S4method{adjust_lambda}{OneStageBasket}(
  design,
  alpha = 0.025,
  p1 = NULL,
  n,
  weight_fun,
  weight_params = list(),
  globalweight_fun = NULL,
  globalweight_params = list(),
  prec_digits,
  ...
)

\S4method{adjust_lambda}{TwoStageBasket}(
  design,
  alpha = 0.025,
  p1 = NULL,
  n,
  n1,
  interim_fun,
  interim_params = list(),
  weight_fun,
  weight_params = list(),
  globalweight_fun = NULL,
  globalweight_params = list(),
  prec_digits,
  ...
)
}
\arguments{
\item{design}{An object of class \code{Basket} created by
\code{setupOneStageBasket} or \code{setupTwoStageBasket}.}

\item{...}{Further arguments.}

\item{alpha}{The one-sided signifance level.}

\item{p1}{Probabilities under the alternative hypothesis. If
\code{length(p1) ==  1}, then this is a common probability for all
baskets. If \code{is.null(p1)} then the type 1 error rate under the
global null hypothesis is computed.}

\item{n}{The sample size per basket.}

\item{weight_fun}{Which function should be used to calculate the pairwise
weights.}

\item{weight_params}{A list of tuning parameters specific to
\code{weight_fun}.}

\item{globalweight_fun}{Which function should be used to calculate the
global weights.}

\item{globalweight_params}{A list of tuning parameters specific to
\code{globalweight_fun}.}

\item{prec_digits}{Number of decimal places that are considered when
adjusting lambda.}

\item{n1}{The sample size per basket for the interim analysis in case of a
two-stage design.}

\item{interim_fun}{Which type of interim analysis should be conducted
in case of a two-stage design.}

\item{interim_params}{A list of tuning parameters specific to
\code{interim_fun}.}
}
\value{
The greatest value with \code{prec_digits} decimal places for
\code{lambda} which controls the family wise error rate at level
\code{alpha} (one-sided) and the exact family wise error rate for this
value of \code{lambda}.
}
\description{
Finds the value for \code{lambda} such that the family wise error
rate is protected at level \code{alpha}.
}
\details{
\code{adjust_alpha} finds the greatest value with
\code{prec_digits} for \code{lambda} which controls the family wise error
rate at level \code{alpha} (one-sided). A combination of the uniroot
function followed by a grid search is used to finde the correct value
for \code{lambda}.
}
\section{Methods (by class)}{
\itemize{
\item \code{adjust_lambda(OneStageBasket)}: Adjust lambda for a single-stage design.

\item \code{adjust_lambda(TwoStageBasket)}: Adjust lambda for a two-stage design.

}}
\examples{
design <- setupOneStageBasket(k = 3, shape1 = 1, shape2 = 1, p0 = 0.2)
adjust_lambda(design = design, alpha = 0.025, n = 15,
  weight_fun = weights_fujikawa, prec_digits = 4)
}
