% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/killJobs.R
\name{killJobs}
\alias{killJobs}
\title{Kill Jobs}
\usage{
killJobs(ids = NULL, reg = getDefaultRegistry())
}
\arguments{
\item{ids}{[\code{\link[base]{data.frame}} or \code{integer}]\cr
A \code{\link[base]{data.frame}} (or \code{\link[data.table]{data.table}})
with a column named \dQuote{job.id}.
Alternatively, you may also pass a vector of integerish job ids.
If not set, defaults to the return value of \code{\link{findOnSystem}}.}

\item{reg}{[\code{\link{Registry}}]\cr
Registry. If not explicitly passed, uses the default registry (see \code{\link{setDefaultRegistry}}).}
}
\value{
[\code{\link{data.table}}] with columns \dQuote{job.id}, the corresponding \dQuote{batch.id} and
  the logical flag \dQuote{killed} indicating success.
}
\description{
Kill jobs which are currently running on the batch system.

In case of an error when killing, the function tries - after a short sleep - to kill the remaining
batch jobs again. If this fails three times for some jobs, the function gives up. Jobs that could be
successfully killed are reset in the \link{Registry}.
}
\seealso{
Other debug: \code{\link{getErrorMessages}},
  \code{\link{getStatus}}, \code{\link{grepLogs}},
  \code{\link{resetJobs}}, \code{\link{showLog}},
  \code{\link{testJob}}
}

