% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bayes_plot.R
\name{bayes_plot_probs}
\alias{bayes_plot_probs}
\title{Plot probability  maps}
\usage{
bayes_plot_probs(
  x,
  scale = 1e-04,
  labels = NULL,
  palette = "YlGnBu",
  tmap_scale = 1
)
}
\arguments{
\item{x}{SpatRaster to be plotted.}

\item{scale}{Scaling factor to apply to the data}

\item{labels}{Labels to be plotted}

\item{palette}{An RColorBrewer palette}

\item{tmap_scale}{Global scale parameter for map (default: 1.0)}
}
\value{
A plot object
}
\description{
Plot probability  maps
}
\examples{
if (bayes_run_examples()) {
    # get the probability file
    data_dir <- system.file("/extdata/probs/", package = "bayesEO")
    file <- list.files(data_dir)
    # build the full path
    probs_file <- paste0(data_dir, "/", file)
    # include the labels
    labels <- c("Water", "ClearCut_Burn", "ClearCut_Soil",
             "ClearCut_Veg", "Forest", "Wetland")
    # associate the labels to the names of the SpatRaster
    probs <- bayes_read_probs(probs_file, labels)
    # Plot the probability image
    bayes_plot_probs(probs,
                     scale = 0.0001,
                     tmap_scale = 1.0)
}

}
\author{
Gilberto Camara, \email{gilberto.camara@inpe.br}
}
